% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputerDecision.default.r
\name{ComputerDecision.default}
\alias{ComputerDecision.default}
\title{Computer player decision}
\usage{
ComputerDecision.default(fit)
}
\arguments{
\item{fit}{an object returned by \code{\link[stats]{lm}}}
}
\value{
An integer between 1 and 4 where 1=non linearity; 2=heteroscedasticity; 3=non normality; 4=no violation
}
\description{
Decides whether a fitted lm objects residuals are such that a violation of the assumptions of non linearity, heteroscedasticity, non normality occurs
}
\examples{
x=rnorm(10)
y=x+rnorm(10,0,0.4)
fit=lm(y~x)
ComputerDecision.default(fit)

x=rnorm(30)
y=x+rt(30,2)
fit=lm(y~x)
ComputerDecision.default(fit)

}
\seealso{
\code{\link{Simulation.default}}, \code{\link{checksim}}
}
\author{
Francesco Pauli, \email{francesco.pauli@deams.units.it}
}
