% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot.lmmsde}
\alias{plot.lmmsde}
\title{Plot of \code{lmmsde} objects}
\usage{
\method{plot}{lmmsde}(x, y, type, smooth, ...)
}
\arguments{
\item{x}{An object of class \code{lmmsde}.}

\item{y}{\code{numeric} or \code{character} value. Either the row index or the row name determining which feature should be plotted.}

\item{type}{a \code{character} indicating what model to plot. Default  \code{'all'}, options: \code{'time'}, \code{'group'},\code{'time*group'}.}

\item{smooth}{an optional \code{logical} value.By default set to \code{FALSE}. If \code{TRUE} smooth representation of the fitted values.}

\item{\ldots}{Additional arguments which are passed to \code{plot}.}
}
\value{
plot showing raw data, mean profile and fitted profile.
}
\description{
Plot of the raw data the mean and the fitted \code{lmmsde} profile.
}
\examples{
\dontrun{
data(kidneySimTimeGroup)
lmmsDEtestl1 <-lmmsDE(data=kidneySimTimeGroup$data,time=kidneySimTimeGroup$time,
                sampleID=kidneySimTimeGroup$sampleID,
                group=kidneySimTimeGroup$group,
                experiment="longitudinal1",basis="p-spline")
plot(lmmsDEtestl1,y=2,type="all")
plot(lmmsDEtestl1,y=2,type="time")
plot(lmmsDEtestl1,y=2,type="group")
plot(lmmsDEtestl1,y=2,type="time*group",smooth=TRUE)}
}

