% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_lme4.R, R/bootstrap_nlme.R,
%   R/generics.R
\name{parametric_bootstrap.lmerMod}
\alias{parametric_bootstrap.lmerMod}
\alias{parametric_bootstrap.lme}
\alias{parametric_bootstrap}
\title{Parametric Bootstrap for Nested LMEs}
\usage{
\method{parametric_bootstrap}{lmerMod}(model, fn, B)

\method{parametric_bootstrap}{lme}(model, fn, B)

parametric_bootstrap(model, fn, B)
}
\arguments{
\item{model}{The model object you wish to bootstrap.}

\item{fn}{A function returning the statistic(s) of interest.}

\item{B}{The number of bootstrap resamples.}
}
\value{
The returned value is an object of class "boot", compatible with the \pkg{boot}
package's \code{\link[boot]{boot}} methods.
}
\description{
Generate parametric bootstrap replicates of a statistic for a nested linear 
mixed-effects model.
}
\details{
The parametric bootstrap simulates bootstrap samples from the estimated 
distribution functions. That is, error terms and random effects are simulated
from their estimated normal distributions and are combined into bootstrap
samples via the fitted model equation.
}
\references{
Chambers, R. and Chandra, H. (2013) A random effect block bootstrap for 
   clustered data. \emph{Journal of Computational and Graphical Statistics}, 
   \bold{22}, 452--470.
   
   Van der Leeden, R., Meijer, E. and Busing F. M. (2008) Resampling multilevel 
   models. In J. de Leeuw and E. Meijer, editors, \emph{Handbook of 
   Multilevel Analysis}, pages 401--433. New York: Springer.
}
\seealso{
\itemize{
  \item \code{\link{parametric_bootstrap}}, \code{\link{resid_bootstrap}},
     \code{\link{case_bootstrap}}, \code{\link{cgr_bootstrap}}, 
     \code{\link{reb_bootstrap}} for more details on a specific bootstrap.
  \item \code{\link[lme4]{bootMer}} in the \pkg{lme4} package for an 
     implementation of (semi-)parameteric bootstrap for mixed models.
  \item \code{\link[boot]{boot}}, \code{\link[boot]{boot.ci}}, and \code{\link[boot]{plot.boot}} 
     from the \pkg{boot} package.
}
}
