% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{write_literanger}
\alias{write_literanger}
\title{Serialize random forest}
\usage{
write_literanger(object, file, verbose = TRUE, ...)
}
\arguments{
\item{object}{A trained random forest \code{literanger} object.}

\item{file}{A connection or the name of the file where the \code{literanger}
object will be saved.}

\item{verbose}{Show additional serialization information (not implemented).}

\item{...}{Further arguments passed to \code{\link[=saveRDS]{saveRDS()}}.}
}
\description{
Write a random forest to a file or connection using light-weight
serialization for C++ objects.
}
\details{
This function uses \href{https://uscilab.github.io/cereal/}{'cereal'} light-weight serialization to
write a literanger object (random forest) to a file or connection. The
file can be read in via \code{\link[=read_literanger]{read_literanger()}} and used for prediction
with no requirement for the original training data.
}
\examples{
## Classification forest
train_idx <- sample(nrow(iris), 2/3 * nrow(iris))
iris_train <- iris[ train_idx, ]
iris_test  <- iris[-train_idx, ]
rf_iris <- train(data=iris_train, response_name="Species")
file <- tempfile()
write_literanger(rf_iris, file)
rf_copy <- read_literanger(file)
pred_bagged <- predict(rf_copy, newdata=iris_test, prediction_type="bagged")

}
\seealso{
\code{\link[=read_literanger]{read_literanger()}} \link{saveRDS}
}
\author{
stephematician \href{mailto:stephematician@gmail.com}{stephematician@gmail.com}
}
