% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactjson.R
\name{reactjson}
\alias{reactjson}
\title{Edit R Data with 'react-json'}
\usage{
reactjson(listdata = list(), width = NULL, height = NULL,
  elementId = NULL)
}
\arguments{
\item{listdata}{\code{list} or \code{String} data to view.  Although designed for \code{lists}, \code{listdata} can
be any data source that can be rendered into \code{JSON} with \code{jsonlite}.  Alternately,
\code{listdata} could be a \code{String} of valid \code{JSON}.  This might be helpful
when dealing with an API response.}

\item{width}{integer in pixels defining the width of the \code{div} container.}

\item{height}{integer in pixels defining the height of the \code{div} container.}

\item{elementId}{character to specify valid \code{CSS} id of the
htmlwidget for special situations in which you want a non-random
identifier.}
}
\description{
Edit R Data with 'react-json'
}
\examples{
\dontrun{

library(listviewer)

# use reactR for React dependencies
# devtools::install_github("timelyportfolio/reactR")
library(reactR)

reactjson()

reactjson(head(mtcars,4))
reactjson(I(jsonlite::toJSON(head(mtcars,5))))

library(shiny)

shinyApp(
  ui = reactjson(
    list(x=1,msg="react+r+shiny",opts=list(use_react=FALSE)),
    elementId = "json1"
  ),
  server = function(input, output, session){
    observeEvent(
      input$json1_change,
      str(input$json1_change)
    )
  }
)


# gadget to use as editor
library(miniUI)
ui <- miniUI::miniPage(
  miniUI::miniContentPanel(
    reactjson(
      list(x=1,msg="react+r+shiny",opts=list(use_react=FALSE)),
      elementId = "rjeditor"
    )
  ),
  miniUI::gadgetTitleBar(
    "Edit",
    right = miniUI::miniTitleBarButton("done", "Done", primary = TRUE)
  )
)

server <- function(input, output, session) {
  shiny::observeEvent(input$done, {
    shiny::stopApp(
      input$rjeditor_change
    )
  })

  shiny::observeEvent(input$cancel, { shiny::stopApp (NULL) })
}

runGadget(
  ui,
  server,
  viewer = shiny::paneViewer()
)

}
}
