% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-site.r
\name{ld_create_doc}
\alias{ld_create_doc}
\title{Create a Document from a `listdown` Bundle}
\usage{
ld_create_doc(
  ldb,
  rmd_file_name = basename(tempfile(pattern = "rmarkdown", fileext = ".Rmd")),
  rmd_dir = tempdir(),
  output_dir = rmd_dir,
  render_doc = TRUE,
  cc_file_name = NULL,
  data_dir = ".",
  view = interactive(),
  ...
)
}
\arguments{
\item{ldb}{a listdown doc bundle.}

\item{rmd_file_name}{the name of the R Markdown file to create. By default,
a temporary file is created.}

\item{rmd_dir}{the directory where the output R Markdown file should be
written to. By default, this is `tempdir()`.}

\item{output_dir}{the location of the rendered document, relative to the 
directory specified by `rmd_dir`. Note that this is an {{rmarkdown}}
convention. By default a directory names "pres" is created in the 
directory specified by `rmd_dir` and rendered documents are place there.}

\item{render_doc}{should the page be rendered? If not then the 
`output_dir` is not created.}

\item{cc_file_name}{the name of the list specifying the computational 
components. If this is `NULL` (the default) then the listdown bundle
is checked to make sure it's `load_cc_expr` attribute has been specified.
If it is specified, and the bundles `load_cc_expr` has not been specified,
then it will be written to disk (in the corresponding data directory, 
specified by `data_dir`) and read via the `saveRDS()` function.}

\item{data_dir}{the directory where data should be written. If the
`cc_file_name` argument is `NULL` then this argument is ignored. If the
`cc_file_name` argument is specfied but `data_dir` is not, then `tempdir()` 
is used.}

\item{view}{should the output document be opened after rendering? By 
default, if `render_doc` is `TRUE` and this argument is `TRUE` then
the browser will open for you to examine the output.}

\item{...}{options to send to the rmarkdown::render() function.}
}
\description{
This function creates a document, defined by a listdown bundle
in a specified location on disk and, optionally, opens the document in the
browser.
}
\seealso{
ld_bundle_doc
}
