% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenarios.R
\name{plotROC}
\alias{plotROC}
\title{Plots the ROC curve for a result or model}
\usage{
plotROC(x, correct, posValue = NULL, xlim = 0:1, ylim = 0:1, asp = 1,
  type = NULL, pch = "x", add = FALSE, ...)
}
\arguments{
\item{x}{either the result from a \code{\link{test}} or a model}

\item{correct}{either the true values or testing data for the model}

\item{posValue}{the label marking the positive value.
If \code{NULL} (default) then the larger value.}

\item{xlim}{sets better defaults for \code{\link{plot.default}}}

\item{ylim}{sets better defaults for \code{\link{plot.default}}}

\item{asp}{sets better defaults for \code{\link{plot.default}}}

\item{type}{sets better defaults for \code{\link{plot.default}}}

\item{pch}{sets better defaults for \code{\link{plot.default}}}

\item{add}{if `FALSE` (default) produces a new plot and if `TRUE` adds to existing plot.}

\item{...}{gets passed to \code{\link{plot.default}}}
}
\description{
This can be used either using \code{\link{rocSVM}} or \code{\link{lsSVM}}
}
\examples{
\dontrun{
banana <- liquidData('banana-bc')
model <- rocSVM(Y~.,banana$train)

plotROC(model ,banana$test)
# or:
result <- test(model, banana$test)
plotROC(result, banana$test$Y)

model.ls <- lsSVM(Y~., banana$train)
result <- plotROC(model.ls, banana$test)
}
}
\seealso{
rocSVM, lsSVM

\code{\link{rocSVM}}
}
