% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenarios.R
\name{mcSVM}
\alias{mcSVM}
\alias{svmMulticlass}
\title{Multiclass Classification}
\usage{
mcSVM(x, y, ..., predict.prob = FALSE, mc_type = c("AvA_hinge", "OvA_ls",
  "OvA_hinge", "AvA_ls"), do.select = TRUE)

svmMulticlass(x, y, ..., predict.prob = FALSE, mc_type = c("AvA_hinge",
  "OvA_ls", "OvA_hinge", "AvA_ls"), do.select = TRUE)
}
\arguments{
\item{x}{either a formula or the features}

\item{y}{either the data or the labels corresponding to the features \code{x}.
It can be a \code{character} in which case the data is loaded using \code{\link{liquidData}}.
If it is of type \code{liquidData} then after \code{train}ing and \code{select}ion
the model is \code{\link{test}}ed using the testing data (\code{y$test}).}

\item{...}{configuration parameters, see \link{Configuration}. Can be \code{threads=2, display=1, gpus=1,} etc.}

\item{predict.prob}{If \code{TRUE} then a LS-svm will be trained and
the conditional probabilities for the binary classification problems will be estimated.
This also restricts the choices of \code{mc_type} to \code{c("OvA_ls","AvA_ls")}.}

\item{mc_type}{configures the 
the multiclass variants for All-vs-All / One-vs-All and with hinge or least squares loss.}

\item{do.select}{if \code{TRUE} also does the whole selection for this model}
}
\value{
an object of type \code{svm}. Depending on the usage this object
has also \code{$train_errors}, \code{$select_errors}, and \code{$last_result}
properties.
}
\description{
This routine is intended for both binary and multiclass 
classification. The binary classification is treated by
an SVM solver for the classical hinge loss, and for the
multiclass case, one-verus-all and all-versus-all reductions 
to binary classification for the hinge and the least 
squares loss are provided. The error of the very first
task is the overall classification error.
\code{svmMulticlass} is a simple alias of \code{mcSVM}
}
\details{
Please look at the demo-vignette (\code{vignette('demo')}) for more examples.

\code{mcSVM} is best used with \code{factor}-labels. If there are just two levels in the factor,
or just two unique values if it is \code{numeric} than a binary classification is performed.
Else, by using the parameter \code{mc_type} different combinations of all-vs-all (\code{AvA})
and one-vs-all (\code{OvA}) and hinge (\code{hinge}) and least squares loss (\code{ls}) can be used.

If a test is performed then not only the final decision is returned but also
the results of the intermediate binary classifications. This is indicated in the column names.
If the training labels are given by a \code{factor} then the final decision will be encoded
in this factor. If this is the case and \code{AvA_hinge} is used,
then also the binary classification problems will receive the corresponding label...
}
\examples{
model <- mcSVM(Species ~ ., iris)
model <- mcSVM(Species ~ ., iris, mc_type="OvA")
model <- mcSVM(Species ~ ., iris, mc.type="AvA_hi")
model <- mcSVM(Species ~ ., iris, predict.prob=TRUE)

\dontrun{
## a worked example can be seen at

vignette("demo",package="liquidSVM")
}

}
\seealso{
\code{\link{Configuration}}
}
