% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/system_file_linter.R
\name{system_file_linter}
\alias{system_file_linter}
\title{Block usage of \code{file.path()} with \code{system.file()}}
\usage{
system_file_linter()
}
\description{
\code{\link[=system.file]{system.file()}} has a \code{...} argument which, internally, is passed to
\code{\link[=file.path]{file.path()}}, so including it in user code is repetitive.
}
\examples{
# will produce lints
lint(
  text = 'system.file(file.path("path", "to", "data"), package = "foo")',
  linters = system_file_linter()
)

lint(
  text = 'file.path(system.file(package = "foo"), "path", "to", "data")',
  linters = system_file_linter()
)

# okay
lint(
  text = 'system.file("path", "to", "data", package = "foo")',
  linters = system_file_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=consistency_linters]{consistency}, \link[=readability_linters]{readability}
}
