#' Get ISO 639--3 code by language
#'
#' Takes any vector of languages and returns ISO code.
#' @param x A character vector of the languages (can be written in lower case)
#' @author George Moroz <agricolamz@gmail.com>
#' @seealso \code{\link{aff.lang}}, \code{\link{area.lang}}, \code{\link{lat.lang}}, \code{\link{long.lang}}
#' @examples
#' iso.lang('Adyghe')
#' iso.lang(c('Adyghe', 'Udi'))
#' @export

iso.lang <- function(x) {
  if (typeof(x) == "list") {
    x <- unlist(x)
  }
  glottolog <- lingtypology::glottolog
  vapply(x, function(y) {
    ifelse(
      is.glottolog(y, response = TRUE) == TRUE,
      glottolog[tolower(glottolog$language) %in% tolower(y),]$iso,
      NA_character_
    )
  }, character(1))
}
