% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{read.segments}
\alias{read.segments}
\title{Read and Segment Multiple Texts}
\usage{
read.segments(path = ".", segment = NULL, ext = ".txt", subdir = FALSE,
  segment.size = -1, bysentence = FALSE, end_in_quotes = TRUE,
  preclean = FALSE, text = NULL)
}
\arguments{
\item{path}{Path to a folder containing files, or a vector of paths to files. If no folders or files are
recognized in \code{path}, it is treated as \code{text}.}

\item{segment}{Specifies how the text of each file should be segmented. If a character, split at that character;
'\\n' by default. If a number, texts will be broken into that many segments, each with a roughly equal number of
words.}

\item{ext}{The extension of the files you want to read in. '.txt' by default.}

\item{subdir}{Logical; if \code{TRUE}, files in folders in \code{path} will also be included.}

\item{segment.size}{Logical; if specified, \code{segment} will be ignored, and texts will be broken into
segments containing roughly \code{segment.size} number of words.}

\item{bysentence}{Logical; if \code{TRUE}, and \code{segment} is a number or \code{segment.size} is specified,
sentences will be kept together, rather than potentially being broken across segments.}

\item{end_in_quotes}{Logical; if \code{FALSE}, sentence-ending marks (\code{.?!}) will not be considered when
immediately followed by a quotation mark. For example, \code{'"Word." Word.'} would be considered one sentence.}

\item{preclean}{Logical; if \code{TRUE}, text will be cleaned with \code{lma_dict(special)} before
segmentation.}

\item{text}{A character vector with text to be split, used in place of \code{path}. Each entry is treated as a file.}
}
\value{
A \code{data.frame} with columns for file names (\code{input}),
segment number within file (\code{segment}), word count for each segment (\code{WC}), and the text of
each segment (\code{text}).
}
\description{
Split texts by word count or specific characters. Input texts directly, or read them in from files.
}
\examples{
# split preloaded text
read.segments('split this text into two segments', 2)

\dontrun{

# read in all files from the package directory
texts = read.segments(path.package('lingmatch'), ext = '')
texts[, -4]

# segment .txt files in dir in a few ways:
dir = 'path/to/files'

## into 1 line segments
texts_lines = read.segments(dir)

## into 5 even segments each
texts_5segs = read.segments(dir, 5)

## into 50 word segments
texts_50words = read.segments(dir, segment.size = 50)

## into 1 sentence segments
texts_1sent = read.segments(dir, segment.size = 1, bysentence = TRUE)

}
}
