% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_resleverage.R
\name{gg_resleverage}
\alias{gg_resleverage}
\title{Plot residual versus leverage plot in ggplot.}
\usage{
gg_resleverage(fitted.lm, method = "loess", se = FALSE, scale.factor = 1)
}
\arguments{
\item{fitted.lm}{a fitted linear model (i.e. lm, glm) that contains fitted regression}

\item{method}{smoothing method of fitted line on scale-location plot.
eg. "lm", "glm", "gam", "loess", "rlm". See \url{http://docs.ggplot2.org/current/geom_smooth.html}
for more details.}

\item{se}{logical; determines whether se belt should be plotted on plot}

\item{scale.factor}{numeric; scales the point size and linewidth to allow customized viewing. Defaults to 1.}
}
\value{
A ggplot object that contains residual vs. leverage graph
}
\description{
Plot residual versus leverage plot in ggplot.
}
\examples{
library(MASS)
data(Cars93)
cars_lm <- lm(Price ~ Passengers + Length + RPM, data = Cars93)
gg_resleverage(cars_lm)
}
