% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiments.R
\name{compare_groups}
\alias{compare_groups}
\title{Prints statistics on dataset, grouped by group assignments}
\usage{
compare_groups(dataset, person, names_of_groupings = NA,
  addl_grouping_assignments = NA, variables_to_compare)
}
\arguments{
\item{dataset}{dataset from create_dataset that contains all variables
and measures of interest}

\item{person}{an instantiated Person object}

\item{names_of_groupings}{names of groupings to test (default is groupings
in person$groupings)}

\item{addl_grouping_assignments}{list of named dataframes, where each data 
frame provides a mapping from a value of a 
specified variable to group on to the group 
assignment for observations with that value 
for that variable}

\item{variables_to_compare}{variables to print grouped statistics on}
}
\value{
NULL - prints statistics
}
\description{
Groups the dataset by each group assignment named in 
names_of_groupings (must be found in person$groupings, 
or passed in as a dataframe
in the list of addl_grouping_assignments). Prints statistics by group.
}
\examples{
data(EX)

dataset <- create_dataset(person = EX, all_variables = list("util" = c("month"), 
                                  "fitbit_daily" = c("sleepDuration", "steps",
                                  "restingHeartRate")), time_var = c("date"))
                                  
indiv_months <- data.frame("month"= c("Jan", "Feb", "Mar", "Apr", "May",
                                      "Jun", "Jul", "Aug", "Sep", "Oct", 
                                      "Nov", "Dec"),
                           "group" = c(1:12))
compare_groups(dataset, person = EX, 
            addl_grouping_assignments = list("indiv_months" = indiv_months), 
            names_of_groupings = c("indiv_months"),
            variables_to_compare = c("steps", "restingHeartRate"))

       
}
