% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MapSites.R
\name{MapSites}
\alias{MapSites}
\title{Map of sites with highest number of missing species}
\usage{
MapSites(sites, center_lng = NULL, center_lat = NULL)
}
\arguments{
\item{sites}{A data.frame with at least the following columns:
\describe{
  \item{locName}{Name of the location.}
  \item{locId}{eBird identifier of the location.}
  \item{num_new}{Number of new species at site}
  \item{lat}{Numeric latitude in decimal degrees}
  \item{lng}{Numeric longitude in decimal degrees}
}}

\item{center_lng, }{center_lat Numeric decimal degrees longitude and latitude 
of the geographic center used for searching sites.}
}
\value{
A ggmap object.
}
\description{
Map of sites with highest number of missing species
}
\details{
The function is primarily used by \code{SitesReport} via the 
template RMarkdown file used to build reports. It is not intended for 
standalone use.
}
\examples{
\dontrun{
  # Create data frame with required columns
  localities <- data.frame(locName = c("Sweetwater Wetlands", "Reid Park"),
  locID = c("L208918", "L227274"), num_new = c(3, 5),
  lat = c(32.279, 32.210), lng = c(-111.022, -110.924))
  lifeR::MapSites(sites = localities)
}

}
\keyword{internal}
