% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algo_digital_surface_model.r
\name{pitfree}
\alias{pitfree}
\title{Digital Surface Model Algorithm}
\usage{
pitfree(thresholds = c(0, 2, 5, 10, 15), max_edge = c(0, 1),
  subcircle = 0)
}
\arguments{
\item{thresholds}{numeric. Set of height thresholds according to the Khosravipour et al. (2014) algorithm
description (see references)}

\item{max_edge}{numeric. Maximum edge length of a triangle in the Delaunay triangulation.
If a triangle has an edge length greater than this value it will be removed. The first number is the value
for the classical triangulation (threshold = 0, see also \link{dsmtin}), the second number
is the value for the pit-free algorithm (for thresholds > 0). If \code{max_edge = 0} no trimming
is done (see examples).}

\item{subcircle}{numeric. radius of the circles. To obtain fewer empty pixels the algorithm
can replace each return with a circle composed of 8 points (see details).}
}
\description{
This function is made to be used in \link{grid_canopy}. It implements the pit-free algorithm
developed by Khosravipour et al. (2014), which is based on the computation of a set of classical
triangulations at different heights (see references). The \code{subcircle} tweak replaces each
point with 8 points around the original one. This allows for virtual 'emulation' of the fact that
a lidar point is not a point as such, but more realistically a disc. This tweak densifies the point
cloud and the resulting canopy model is smoother and contains fewer 'pits' and empty pixels.
}
\examples{
LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
las <- readLAS(LASfile)
col <- height.colors(50)

# Basic triangulation and rasterization of first returns
chm <- grid_canopy(las, res = 0.5, dsmtin())
plot(chm, col = col)

# Khosravipour et al. pitfree algorithm
chm <- grid_canopy(las, res = 0.5, pitfree(c(0,2,5,10,15), c(0, 1.5)))
plot(chm, col = col)

\dontrun{
# Potentially complex concave subset of point cloud
x = c(481340, 481340, 481280, 481300, 481280, 481340)
y = c(3812940, 3813000, 3813000, 3812960, 3812940, 3812940)
las2 = lasclipPolygon(las,x,y)
plot(las2)

# Since the TIN interpolation is done within the convex hull of the point cloud
# dummy pixels are interpolated that are strictly correct according to the interpolation method
# used, but meaningless in our CHM
chm <- grid_canopy(las2, res = 0.5, pitfree())
plot(chm, col = col)

chm = grid_canopy(las2, res = 0.5, pitfree(max_edge = c(3, 1.5)))
plot(chm, col = col)
}
}
\references{
Khosravipour, A., Skidmore, A. K., Isenburg, M., Wang, T., & Hussin, Y. A. (2014).
Generating pit-free canopy height models from airborne lidar. Photogrammetric Engineering &
Remote Sensing, 80(9), 863-872.
}
\seealso{
Other digital surface model algorithms: \code{\link{dsmtin}},
  \code{\link{p2r}}
}
\concept{digital surface model algorithms}
