% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lashexametrics.r
\name{plot.lashexametrics}
\alias{plot.lashexametrics}
\title{Plot an object of class lashexametrics in 2D}
\usage{
\method{plot}{lashexametrics}(x, z = NULL, colorPalette = height.colors(50),
  ...)
}
\arguments{
\item{x}{A data.table of class \code{lashexametrics}.}

\item{z}{character. The field to plot. If NULL, autodetect.}

\item{colorPalette}{characters. A list of colors such as that generated by heat.colors,
topo.colors, terrain.colors or similar functions.  Default is \code{height.colors(50)}
provided by the package \code{lidR}}

\item{...}{inherited from base}
}
\description{
This functions implements a plot method for \code{lashexametrics} data.table
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile)

# Max Z within
grid_hexametrics(lidar, max(Z), 5) \%>\% plot
}
\seealso{
\link[lidR:grid_metrics]{grid_metrics}
\link[grDevices:heat.colors]{heat.colors}
}
