% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasclip.r
\name{lasclip}
\alias{lasclip}
\alias{lasclipCircle}
\alias{lasclipPolygon}
\alias{lasclipRectangle}
\title{Clip LiDAR points}
\usage{
lasclip(.las, geometry, coord, inside = TRUE)

lasclipRectangle(.las, xleft, ybottom, xright, ytop, inside = TRUE)

lasclipPolygon(.las, x, y, inside = TRUE)

lasclipCircle(.las, xcenter, ycenter, radius, inside = TRUE)
}
\arguments{
\item{.las}{An object of class \code{LAS}}

\item{geometry}{charaters. name of a geometry. Can be \code{"circle"}, \code{"rectangle"},
\code{"polygon"}, \code{"cuboid"} or \code{"sphere"}}

\item{coord}{matrix or data.frame. The coordinates of the minimum points requiered to fully
describe the geometry. For circle a 1-by-3 matrix, for rectangle a 2-by-2 matrix, for polygon n-by-2
matrix, for cuboid 2-by-3 matrix and for sphere a 1-by-4 matrix}

\item{inside}{logical. Keep data inside or outside the shape}

\item{xleft}{scalar. of left x position.}

\item{ybottom}{scalar. of bottom y position.}

\item{xright}{scalar. of right x position.}

\item{ytop}{scalar. of top y position.}

\item{x}{numerical array. x-coordinates of polygon}

\item{y}{numerical array. y-coordinates of polygon}

\item{xcenter}{scalar. x disc center}

\item{ycenter}{calar. y disc center}

\item{radius}{a scalar. Disc radius}
}
\value{
An object of class \code{LAS}
}
\description{
Clip LiDAR points within a given geometry and convenient wrappers most common geometries
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile)

subset = lidar \%>\% lasclipRectangle(xleft  = 684850, ybottom = 5017850,
                                    xright = 684900, ytop    = 5017900)
plot(subset)

msphere = matrix(c(684850, 5017850, 10, 10), ncol = 4)
subset = lidar \%>\% lasclip("sphere", msphere)
plot(subset)

mrect = matrix(c(684850, 684900, 5017850, 5017900), ncol = 2)
subset = lidar \%>\% lasclip("rectangle", mrect)
}

