% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalog_query.r
\name{catalog_queries}
\alias{catalog_queries}
\title{Extract LiDAR data based on a set of coordinates}
\usage{
catalog_queries(obj, x, y, r, r2 = NULL, roinames = NULL, mc.cores = 1,
  ...)
}
\arguments{
\item{obj}{A Catalog object}

\item{x}{vector. A set of x coordinates corresponding to the center of the ROI}

\item{y}{vector. A set of y coordinates corresponding to the center of the ROI}

\item{r}{numeric or vector. A radius or a set of radii of the ROI. If only
r is provided (r2 = NULL) it will extract data falling onto a disc.}

\item{r2}{numeric or vector. A radius or a set of radii of plots. If r2
is provided, the selection turns into a rectangular ROI. If r = r2 it is a square.}

\item{roinames}{vector. A set of ROI names (the ID of the plots, for example)}

\item{mc.cores}{numeric. The number of cores for parallel processing (see \link[parallel:makeCluster]{makeCluster})}

\item{...}{additional parameters for \link[lidR:readLAS]{readLAS}}
}
\value{
A list of LAS objects
}
\description{
When the user has a set of (x, y) coordinates corresponding to a region of interest (ROI),
a ground inventory for example, they can automatically extract the lidar data associated
with the ROIs from a \link[lidR:catalog]{Catalog}. The algorithm will do this even for ROIs
falling on the edges of one or more tiles.\cr
It works only for tiles that are arranged in gridlines.
}
\examples{
\dontrun{
# Build a Catalog
catalog = catalog("<Path to a folder containing a set of .las or .laz files>")

# Get coordinates from an external file
X = runif(30, 690000, 800000)
Y = runif(30, 5010000, 5020000)
R = 25

# Return a List of 30 circular LAS objects of 25 m radius
catalog \%>\% catalog_queries(X, Y, R)

# Return a List of 30 square LAS objects of 50x50 m
catalog \%>\% catalog_queries(X, Y, R, R)
}
}
\seealso{
\link[lidR:readLAS]{readLAS}
\link[lidR:catalog]{Catalog}
\link[lidR:catalog_queries]{catalog_queries}
}

