/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/InformationCriteria.h>
#include <so/private/InformationCriteria.h>

so_InformationCriteria *so_InformationCriteria_new()
{
	so_InformationCriteria *object = calloc(sizeof(so_InformationCriteria), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_InformationCriteria *so_InformationCriteria_copy(so_InformationCriteria *self)
{
	so_InformationCriteria *dest = so_InformationCriteria_new();
	if (dest) {
		if (self->AIC) {
			dest->AIC_number = self->AIC_number;
			dest->AIC = &(dest->AIC_number);
		}
		if (self->BIC) {
			dest->BIC_number = self->BIC_number;
			dest->BIC = &(dest->BIC_number);
		}
		if (self->DIC) {
			dest->DIC_number = self->DIC_number;
			dest->DIC = &(dest->DIC_number);
		}
	}

	return dest;
}

void so_InformationCriteria_free(so_InformationCriteria *self)
{
	if (self) {
		free(self);
	}
}

void so_InformationCriteria_ref(so_InformationCriteria *self)
{
	self->reference_count++;
}

void so_InformationCriteria_unref(so_InformationCriteria *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_InformationCriteria_free(self);
		}
	}
}

double *so_InformationCriteria_get_AIC(so_InformationCriteria *self)
{
	return self->AIC;
}

double *so_InformationCriteria_get_BIC(so_InformationCriteria *self)
{
	return self->BIC;
}

double *so_InformationCriteria_get_DIC(so_InformationCriteria *self)
{
	return self->DIC;
}

void so_InformationCriteria_set_AIC(so_InformationCriteria *self, double *value)
{
	if (value) {
		self->AIC_number = *value;
		self->AIC = &(self->AIC_number);
	} else {
		self->AIC = value;
	}
}

void so_InformationCriteria_set_BIC(so_InformationCriteria *self, double *value)
{
	if (value) {
		self->BIC_number = *value;
		self->BIC = &(self->BIC_number);
	} else {
		self->BIC = value;
	}
}

void so_InformationCriteria_set_DIC(so_InformationCriteria *self, double *value)
{
	if (value) {
		self->DIC_number = *value;
		self->DIC = &(self->DIC_number);
	} else {
		self->DIC = value;
	}
}

int so_InformationCriteria_xml(so_InformationCriteria *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->AIC || self->BIC || self->DIC) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "InformationCriteria");
		if (rc < 0) return 1;
		if (self->AIC) {
			char *number_string = pharmml_double_to_string(self->AIC_number);
			if (!number_string) return 1;
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "AIC", BAD_CAST number_string);
			free(number_string);
			if (rc < 0) return 1;
		}
		if (self->BIC) {
			char *number_string = pharmml_double_to_string(self->BIC_number);
			if (!number_string) return 1;
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "BIC", BAD_CAST number_string);
			free(number_string);
			if (rc < 0) return 1;
		}
		if (self->DIC) {
			char *number_string = pharmml_double_to_string(self->DIC_number);
			if (!number_string) return 1;
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "DIC", BAD_CAST number_string);
			free(number_string);
			if (rc < 0) return 1;
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_InformationCriteria_start_element(so_InformationCriteria *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (strcmp(localname, "AIC") == 0) {
		self->in_AIC = 1;
	} else if (strcmp(localname, "BIC") == 0) {
		self->in_BIC = 1;
	} else if (strcmp(localname, "DIC") == 0) {
		self->in_DIC = 1;
	}
	return 0;
}

void so_InformationCriteria_end_element(so_InformationCriteria *self, const char *localname)
{
	if (strcmp(localname, "AIC") == 0 && self->in_AIC) {
		self->in_AIC = 0;
	} else if (strcmp(localname, "BIC") == 0 && self->in_BIC) {
		self->in_BIC = 0;
	} else if (strcmp(localname, "DIC") == 0 && self->in_DIC) {
		self->in_DIC = 0;
	}
}

int so_InformationCriteria_characters(so_InformationCriteria *self, const char *ch, int len)
{
	if (self->in_AIC) {
		self->AIC_number = pharmml_string_to_double(ch);
		self->AIC = &(self->AIC_number);
	} else if (self->in_BIC) {
		self->BIC_number = pharmml_string_to_double(ch);
		self->BIC = &(self->BIC_number);
	} else if (self->in_DIC) {
		self->DIC_number = pharmml_string_to_double(ch);
		self->DIC = &(self->DIC_number);
	}
	return 0;
}
