/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/SimulationBlock.h>
#include <so/private/SimulationBlock.h>

so_SimulationBlock *so_SimulationBlock_new()
{
	so_SimulationBlock *object = calloc(sizeof(so_SimulationBlock), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_SimulationBlock *so_SimulationBlock_copy(so_SimulationBlock *self)
{
	so_SimulationBlock *dest = so_SimulationBlock_new();
	if (dest) {
		if (self->replicate) {
			dest->replicate_number = self->replicate_number;
			dest->replicate = &(dest->replicate_number);
		}
		if (self->num_SimulatedProfiles) {
			dest->SimulatedProfiles = calloc(self->num_SimulatedProfiles * sizeof(so_SimulationSubType *), 1);
			if (!dest->SimulatedProfiles) {
				so_SimulationBlock_free(dest);
				return NULL;
			}
			dest->num_SimulatedProfiles = self->num_SimulatedProfiles;
			for (int i = 0; i < self->num_SimulatedProfiles; i++) {
				dest->SimulatedProfiles[i] = so_SimulationSubType_copy(self->SimulatedProfiles[i]);
				if (!dest->SimulatedProfiles[i]) {
					so_SimulationBlock_free(dest);
					return NULL;
				}
			}
		}
		if (self->num_IndivParameters) {
			dest->IndivParameters = calloc(self->num_IndivParameters * sizeof(so_SimulationSubType *), 1);
			if (!dest->IndivParameters) {
				so_SimulationBlock_free(dest);
				return NULL;
			}
			dest->num_IndivParameters = self->num_IndivParameters;
			for (int i = 0; i < self->num_IndivParameters; i++) {
				dest->IndivParameters[i] = so_SimulationSubType_copy(self->IndivParameters[i]);
				if (!dest->IndivParameters[i]) {
					so_SimulationBlock_free(dest);
					return NULL;
				}
			}
		}
		if (self->num_RandomEffects) {
			dest->RandomEffects = calloc(self->num_RandomEffects * sizeof(so_SimulationSubType *), 1);
			if (!dest->RandomEffects) {
				so_SimulationBlock_free(dest);
				return NULL;
			}
			dest->num_RandomEffects = self->num_RandomEffects;
			for (int i = 0; i < self->num_RandomEffects; i++) {
				dest->RandomEffects[i] = so_SimulationSubType_copy(self->RandomEffects[i]);
				if (!dest->RandomEffects[i]) {
					so_SimulationBlock_free(dest);
					return NULL;
				}
			}
		}
		if (self->num_Covariates) {
			dest->Covariates = calloc(self->num_Covariates * sizeof(so_SimulationSubType *), 1);
			if (!dest->Covariates) {
				so_SimulationBlock_free(dest);
				return NULL;
			}
			dest->num_Covariates = self->num_Covariates;
			for (int i = 0; i < self->num_Covariates; i++) {
				dest->Covariates[i] = so_SimulationSubType_copy(self->Covariates[i]);
				if (!dest->Covariates[i]) {
					so_SimulationBlock_free(dest);
					return NULL;
				}
			}
		}
		if (self->num_Regressors) {
			dest->Regressors = calloc(self->num_Regressors * sizeof(so_SimulationSubType *), 1);
			if (!dest->Regressors) {
				so_SimulationBlock_free(dest);
				return NULL;
			}
			dest->num_Regressors = self->num_Regressors;
			for (int i = 0; i < self->num_Regressors; i++) {
				dest->Regressors[i] = so_SimulationSubType_copy(self->Regressors[i]);
				if (!dest->Regressors[i]) {
					so_SimulationBlock_free(dest);
					return NULL;
				}
			}
		}
		if (self->num_PopulationParameters) {
			dest->PopulationParameters = calloc(self->num_PopulationParameters * sizeof(so_SimulationSubType *), 1);
			if (!dest->PopulationParameters) {
				so_SimulationBlock_free(dest);
				return NULL;
			}
			dest->num_PopulationParameters = self->num_PopulationParameters;
			for (int i = 0; i < self->num_PopulationParameters; i++) {
				dest->PopulationParameters[i] = so_SimulationSubType_copy(self->PopulationParameters[i]);
				if (!dest->PopulationParameters[i]) {
					so_SimulationBlock_free(dest);
					return NULL;
				}
			}
		}
		if (self->num_Dosing) {
			dest->Dosing = calloc(self->num_Dosing * sizeof(so_SimulationSubType *), 1);
			if (!dest->Dosing) {
				so_SimulationBlock_free(dest);
				return NULL;
			}
			dest->num_Dosing = self->num_Dosing;
			for (int i = 0; i < self->num_Dosing; i++) {
				dest->Dosing[i] = so_SimulationSubType_copy(self->Dosing[i]);
				if (!dest->Dosing[i]) {
					so_SimulationBlock_free(dest);
					return NULL;
				}
			}
		}
		if (self->RawResultsFile) {
			dest->RawResultsFile = so_ExternalFile_copy(self->RawResultsFile);
			if (!dest->RawResultsFile) {
				so_SimulationBlock_free(dest);
				return NULL;
			}
		}
	}

	return dest;
}

void so_SimulationBlock_free(so_SimulationBlock *self)
{
	if (self) {
		for(int i = 0; i < self->num_SimulatedProfiles; i++) {
			so_SimulationSubType_unref(self->SimulatedProfiles[i]);
		}
		free(self->SimulatedProfiles);
		for(int i = 0; i < self->num_IndivParameters; i++) {
			so_SimulationSubType_unref(self->IndivParameters[i]);
		}
		free(self->IndivParameters);
		for(int i = 0; i < self->num_RandomEffects; i++) {
			so_SimulationSubType_unref(self->RandomEffects[i]);
		}
		free(self->RandomEffects);
		for(int i = 0; i < self->num_Covariates; i++) {
			so_SimulationSubType_unref(self->Covariates[i]);
		}
		free(self->Covariates);
		for(int i = 0; i < self->num_Regressors; i++) {
			so_SimulationSubType_unref(self->Regressors[i]);
		}
		free(self->Regressors);
		for(int i = 0; i < self->num_PopulationParameters; i++) {
			so_SimulationSubType_unref(self->PopulationParameters[i]);
		}
		free(self->PopulationParameters);
		for(int i = 0; i < self->num_Dosing; i++) {
			so_SimulationSubType_unref(self->Dosing[i]);
		}
		free(self->Dosing);
		so_ExternalFile_unref(self->RawResultsFile);
		free(self);
	}
}

void so_SimulationBlock_ref(so_SimulationBlock *self)
{
	self->reference_count++;
}

void so_SimulationBlock_unref(so_SimulationBlock *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_SimulationBlock_free(self);
		}
	}
}

int *so_SimulationBlock_get_replicate(so_SimulationBlock *self)
{
	return self->replicate;
}

so_SimulationSubType *so_SimulationBlock_get_SimulatedProfiles(so_SimulationBlock *self, int number)
{
	return self->SimulatedProfiles[number];
}

so_SimulationSubType *so_SimulationBlock_get_IndivParameters(so_SimulationBlock *self, int number)
{
	return self->IndivParameters[number];
}

so_SimulationSubType *so_SimulationBlock_get_RandomEffects(so_SimulationBlock *self, int number)
{
	return self->RandomEffects[number];
}

so_SimulationSubType *so_SimulationBlock_get_Covariates(so_SimulationBlock *self, int number)
{
	return self->Covariates[number];
}

so_SimulationSubType *so_SimulationBlock_get_Regressors(so_SimulationBlock *self, int number)
{
	return self->Regressors[number];
}

so_SimulationSubType *so_SimulationBlock_get_PopulationParameters(so_SimulationBlock *self, int number)
{
	return self->PopulationParameters[number];
}

so_SimulationSubType *so_SimulationBlock_get_Dosing(so_SimulationBlock *self, int number)
{
	return self->Dosing[number];
}

so_ExternalFile *so_SimulationBlock_get_RawResultsFile(so_SimulationBlock *self)
{
	return self->RawResultsFile;
}

int so_SimulationBlock_get_number_of_SimulatedProfiles(so_SimulationBlock *self)
{
	return self->num_SimulatedProfiles;
}

int so_SimulationBlock_get_number_of_IndivParameters(so_SimulationBlock *self)
{
	return self->num_IndivParameters;
}

int so_SimulationBlock_get_number_of_RandomEffects(so_SimulationBlock *self)
{
	return self->num_RandomEffects;
}

int so_SimulationBlock_get_number_of_Covariates(so_SimulationBlock *self)
{
	return self->num_Covariates;
}

int so_SimulationBlock_get_number_of_Regressors(so_SimulationBlock *self)
{
	return self->num_Regressors;
}

int so_SimulationBlock_get_number_of_PopulationParameters(so_SimulationBlock *self)
{
	return self->num_PopulationParameters;
}

int so_SimulationBlock_get_number_of_Dosing(so_SimulationBlock *self)
{
	return self->num_Dosing;
}

void so_SimulationBlock_set_replicate(so_SimulationBlock *self, int *value)
{
	if (value) {
		self->replicate_number = *value;
		self->replicate = &(self->replicate_number);
	} else {
		self->replicate = value;
	}
}

void so_SimulationBlock_set_RawResultsFile(so_SimulationBlock *self, so_ExternalFile *value)
{
	so_ExternalFile_unref(self->RawResultsFile);
	self->RawResultsFile = value;
}

so_SimulationSubType *so_SimulationBlock_create_SimulatedProfiles(so_SimulationBlock *self)
{
	so_SimulationSubType *obj = so_SimulationSubType_new("SimulatedProfiles");
	if (obj) {
		so_SimulationSubType **newblock = realloc(self->SimulatedProfiles, (self->num_SimulatedProfiles + 1) * sizeof(so_SimulationSubType *));
		if (newblock) {
			self->SimulatedProfiles = newblock;
			self->SimulatedProfiles[self->num_SimulatedProfiles] = obj;
			self->num_SimulatedProfiles++;
		} else {
			so_SimulationSubType_free(obj);
			obj = NULL;
		}
	}
	return obj;
}

so_SimulationSubType *so_SimulationBlock_create_IndivParameters(so_SimulationBlock *self)
{
	so_SimulationSubType *obj = so_SimulationSubType_new("IndivParameters");
	if (obj) {
		so_SimulationSubType **newblock = realloc(self->IndivParameters, (self->num_IndivParameters + 1) * sizeof(so_SimulationSubType *));
		if (newblock) {
			self->IndivParameters = newblock;
			self->IndivParameters[self->num_IndivParameters] = obj;
			self->num_IndivParameters++;
		} else {
			so_SimulationSubType_free(obj);
			obj = NULL;
		}
	}
	return obj;
}

so_SimulationSubType *so_SimulationBlock_create_RandomEffects(so_SimulationBlock *self)
{
	so_SimulationSubType *obj = so_SimulationSubType_new("RandomEffects");
	if (obj) {
		so_SimulationSubType **newblock = realloc(self->RandomEffects, (self->num_RandomEffects + 1) * sizeof(so_SimulationSubType *));
		if (newblock) {
			self->RandomEffects = newblock;
			self->RandomEffects[self->num_RandomEffects] = obj;
			self->num_RandomEffects++;
		} else {
			so_SimulationSubType_free(obj);
			obj = NULL;
		}
	}
	return obj;
}

so_SimulationSubType *so_SimulationBlock_create_Covariates(so_SimulationBlock *self)
{
	so_SimulationSubType *obj = so_SimulationSubType_new("Covariates");
	if (obj) {
		so_SimulationSubType **newblock = realloc(self->Covariates, (self->num_Covariates + 1) * sizeof(so_SimulationSubType *));
		if (newblock) {
			self->Covariates = newblock;
			self->Covariates[self->num_Covariates] = obj;
			self->num_Covariates++;
		} else {
			so_SimulationSubType_free(obj);
			obj = NULL;
		}
	}
	return obj;
}

so_SimulationSubType *so_SimulationBlock_create_Regressors(so_SimulationBlock *self)
{
	so_SimulationSubType *obj = so_SimulationSubType_new("Regressors");
	if (obj) {
		so_SimulationSubType **newblock = realloc(self->Regressors, (self->num_Regressors + 1) * sizeof(so_SimulationSubType *));
		if (newblock) {
			self->Regressors = newblock;
			self->Regressors[self->num_Regressors] = obj;
			self->num_Regressors++;
		} else {
			so_SimulationSubType_free(obj);
			obj = NULL;
		}
	}
	return obj;
}

so_SimulationSubType *so_SimulationBlock_create_PopulationParameters(so_SimulationBlock *self)
{
	so_SimulationSubType *obj = so_SimulationSubType_new("PopulationParameters");
	if (obj) {
		so_SimulationSubType **newblock = realloc(self->PopulationParameters, (self->num_PopulationParameters + 1) * sizeof(so_SimulationSubType *));
		if (newblock) {
			self->PopulationParameters = newblock;
			self->PopulationParameters[self->num_PopulationParameters] = obj;
			self->num_PopulationParameters++;
		} else {
			so_SimulationSubType_free(obj);
			obj = NULL;
		}
	}
	return obj;
}

so_SimulationSubType *so_SimulationBlock_create_Dosing(so_SimulationBlock *self)
{
	so_SimulationSubType *obj = so_SimulationSubType_new("Dosing");
	if (obj) {
		so_SimulationSubType **newblock = realloc(self->Dosing, (self->num_Dosing + 1) * sizeof(so_SimulationSubType *));
		if (newblock) {
			self->Dosing = newblock;
			self->Dosing[self->num_Dosing] = obj;
			self->num_Dosing++;
		} else {
			so_SimulationSubType_free(obj);
			obj = NULL;
		}
	}
	return obj;
}

so_ExternalFile *so_SimulationBlock_create_RawResultsFile(so_SimulationBlock *self)
{
	so_ExternalFile *obj = so_ExternalFile_new("RawResultsFile");
	if (obj) {
		self->RawResultsFile = obj;
	}
	return obj;
}

int so_SimulationBlock_add_SimulatedProfiles(so_SimulationBlock *self, so_SimulationSubType *child)
{
	so_SimulationSubType **new_array = realloc(self->SimulatedProfiles, (self->num_SimulatedProfiles + 1) * sizeof(so_SimulationSubType *));
	if (!new_array) {
		return 1;
	}
	self->SimulatedProfiles = new_array;
	self->SimulatedProfiles[self->num_SimulatedProfiles] = child;
	self->num_SimulatedProfiles++;
	return 0;
}

int so_SimulationBlock_remove_SimulatedProfiles(so_SimulationBlock *self, int index)
{
	int size = self->num_SimulatedProfiles;
	if (index >= size) {
		return 0;
	}
	if (size == 1) {
		free(self->SimulatedProfiles);
		self->SimulatedProfiles = NULL;
		return 0;
	}
	so_SimulationSubType *final = self->SimulatedProfiles[size - 1];
	so_SimulationSubType *remove = self->SimulatedProfiles[index];
	so_SimulationSubType **new_array = realloc(self->SimulatedProfiles, (self->num_SimulatedProfiles - 1) * sizeof(so_SimulationSubType *));
	if (!new_array) {
		return 1;
	}
	self->num_SimulatedProfiles--;
	if (final == remove) {
		return 0;
	}
	for (int i = index; i < size - 3; i++) {
		self->SimulatedProfiles[i] = self->SimulatedProfiles[i + 1];
	}
	self->SimulatedProfiles[size - 2] = final;
	so_SimulationSubType_unref(remove);
	return 0;
}

int so_SimulationBlock_add_IndivParameters(so_SimulationBlock *self, so_SimulationSubType *child)
{
	so_SimulationSubType **new_array = realloc(self->IndivParameters, (self->num_IndivParameters + 1) * sizeof(so_SimulationSubType *));
	if (!new_array) {
		return 1;
	}
	self->IndivParameters = new_array;
	self->IndivParameters[self->num_IndivParameters] = child;
	self->num_IndivParameters++;
	return 0;
}

int so_SimulationBlock_remove_IndivParameters(so_SimulationBlock *self, int index)
{
	int size = self->num_IndivParameters;
	if (index >= size) {
		return 0;
	}
	if (size == 1) {
		free(self->IndivParameters);
		self->IndivParameters = NULL;
		return 0;
	}
	so_SimulationSubType *final = self->IndivParameters[size - 1];
	so_SimulationSubType *remove = self->IndivParameters[index];
	so_SimulationSubType **new_array = realloc(self->IndivParameters, (self->num_IndivParameters - 1) * sizeof(so_SimulationSubType *));
	if (!new_array) {
		return 1;
	}
	self->num_IndivParameters--;
	if (final == remove) {
		return 0;
	}
	for (int i = index; i < size - 3; i++) {
		self->IndivParameters[i] = self->IndivParameters[i + 1];
	}
	self->IndivParameters[size - 2] = final;
	so_SimulationSubType_unref(remove);
	return 0;
}

int so_SimulationBlock_add_RandomEffects(so_SimulationBlock *self, so_SimulationSubType *child)
{
	so_SimulationSubType **new_array = realloc(self->RandomEffects, (self->num_RandomEffects + 1) * sizeof(so_SimulationSubType *));
	if (!new_array) {
		return 1;
	}
	self->RandomEffects = new_array;
	self->RandomEffects[self->num_RandomEffects] = child;
	self->num_RandomEffects++;
	return 0;
}

int so_SimulationBlock_remove_RandomEffects(so_SimulationBlock *self, int index)
{
	int size = self->num_RandomEffects;
	if (index >= size) {
		return 0;
	}
	if (size == 1) {
		free(self->RandomEffects);
		self->RandomEffects = NULL;
		return 0;
	}
	so_SimulationSubType *final = self->RandomEffects[size - 1];
	so_SimulationSubType *remove = self->RandomEffects[index];
	so_SimulationSubType **new_array = realloc(self->RandomEffects, (self->num_RandomEffects - 1) * sizeof(so_SimulationSubType *));
	if (!new_array) {
		return 1;
	}
	self->num_RandomEffects--;
	if (final == remove) {
		return 0;
	}
	for (int i = index; i < size - 3; i++) {
		self->RandomEffects[i] = self->RandomEffects[i + 1];
	}
	self->RandomEffects[size - 2] = final;
	so_SimulationSubType_unref(remove);
	return 0;
}

int so_SimulationBlock_add_Covariates(so_SimulationBlock *self, so_SimulationSubType *child)
{
	so_SimulationSubType **new_array = realloc(self->Covariates, (self->num_Covariates + 1) * sizeof(so_SimulationSubType *));
	if (!new_array) {
		return 1;
	}
	self->Covariates = new_array;
	self->Covariates[self->num_Covariates] = child;
	self->num_Covariates++;
	return 0;
}

int so_SimulationBlock_remove_Covariates(so_SimulationBlock *self, int index)
{
	int size = self->num_Covariates;
	if (index >= size) {
		return 0;
	}
	if (size == 1) {
		free(self->Covariates);
		self->Covariates = NULL;
		return 0;
	}
	so_SimulationSubType *final = self->Covariates[size - 1];
	so_SimulationSubType *remove = self->Covariates[index];
	so_SimulationSubType **new_array = realloc(self->Covariates, (self->num_Covariates - 1) * sizeof(so_SimulationSubType *));
	if (!new_array) {
		return 1;
	}
	self->num_Covariates--;
	if (final == remove) {
		return 0;
	}
	for (int i = index; i < size - 3; i++) {
		self->Covariates[i] = self->Covariates[i + 1];
	}
	self->Covariates[size - 2] = final;
	so_SimulationSubType_unref(remove);
	return 0;
}

int so_SimulationBlock_add_Regressors(so_SimulationBlock *self, so_SimulationSubType *child)
{
	so_SimulationSubType **new_array = realloc(self->Regressors, (self->num_Regressors + 1) * sizeof(so_SimulationSubType *));
	if (!new_array) {
		return 1;
	}
	self->Regressors = new_array;
	self->Regressors[self->num_Regressors] = child;
	self->num_Regressors++;
	return 0;
}

int so_SimulationBlock_remove_Regressors(so_SimulationBlock *self, int index)
{
	int size = self->num_Regressors;
	if (index >= size) {
		return 0;
	}
	if (size == 1) {
		free(self->Regressors);
		self->Regressors = NULL;
		return 0;
	}
	so_SimulationSubType *final = self->Regressors[size - 1];
	so_SimulationSubType *remove = self->Regressors[index];
	so_SimulationSubType **new_array = realloc(self->Regressors, (self->num_Regressors - 1) * sizeof(so_SimulationSubType *));
	if (!new_array) {
		return 1;
	}
	self->num_Regressors--;
	if (final == remove) {
		return 0;
	}
	for (int i = index; i < size - 3; i++) {
		self->Regressors[i] = self->Regressors[i + 1];
	}
	self->Regressors[size - 2] = final;
	so_SimulationSubType_unref(remove);
	return 0;
}

int so_SimulationBlock_add_PopulationParameters(so_SimulationBlock *self, so_SimulationSubType *child)
{
	so_SimulationSubType **new_array = realloc(self->PopulationParameters, (self->num_PopulationParameters + 1) * sizeof(so_SimulationSubType *));
	if (!new_array) {
		return 1;
	}
	self->PopulationParameters = new_array;
	self->PopulationParameters[self->num_PopulationParameters] = child;
	self->num_PopulationParameters++;
	return 0;
}

int so_SimulationBlock_remove_PopulationParameters(so_SimulationBlock *self, int index)
{
	int size = self->num_PopulationParameters;
	if (index >= size) {
		return 0;
	}
	if (size == 1) {
		free(self->PopulationParameters);
		self->PopulationParameters = NULL;
		return 0;
	}
	so_SimulationSubType *final = self->PopulationParameters[size - 1];
	so_SimulationSubType *remove = self->PopulationParameters[index];
	so_SimulationSubType **new_array = realloc(self->PopulationParameters, (self->num_PopulationParameters - 1) * sizeof(so_SimulationSubType *));
	if (!new_array) {
		return 1;
	}
	self->num_PopulationParameters--;
	if (final == remove) {
		return 0;
	}
	for (int i = index; i < size - 3; i++) {
		self->PopulationParameters[i] = self->PopulationParameters[i + 1];
	}
	self->PopulationParameters[size - 2] = final;
	so_SimulationSubType_unref(remove);
	return 0;
}

int so_SimulationBlock_add_Dosing(so_SimulationBlock *self, so_SimulationSubType *child)
{
	so_SimulationSubType **new_array = realloc(self->Dosing, (self->num_Dosing + 1) * sizeof(so_SimulationSubType *));
	if (!new_array) {
		return 1;
	}
	self->Dosing = new_array;
	self->Dosing[self->num_Dosing] = child;
	self->num_Dosing++;
	return 0;
}

int so_SimulationBlock_remove_Dosing(so_SimulationBlock *self, int index)
{
	int size = self->num_Dosing;
	if (index >= size) {
		return 0;
	}
	if (size == 1) {
		free(self->Dosing);
		self->Dosing = NULL;
		return 0;
	}
	so_SimulationSubType *final = self->Dosing[size - 1];
	so_SimulationSubType *remove = self->Dosing[index];
	so_SimulationSubType **new_array = realloc(self->Dosing, (self->num_Dosing - 1) * sizeof(so_SimulationSubType *));
	if (!new_array) {
		return 1;
	}
	self->num_Dosing--;
	if (final == remove) {
		return 0;
	}
	for (int i = index; i < size - 3; i++) {
		self->Dosing[i] = self->Dosing[i + 1];
	}
	self->Dosing[size - 2] = final;
	so_SimulationSubType_unref(remove);
	return 0;
}

int so_SimulationBlock_xml(so_SimulationBlock *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->SimulatedProfiles || self->IndivParameters || self->RandomEffects || self->Covariates || self->Regressors || self->PopulationParameters || self->Dosing || self->RawResultsFile || self->replicate) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "SimulationBlock");
		if (rc < 0) return 1;
		if (self->replicate) {
			char *attr_string = pharmml_int_to_string(self->replicate_number);
			if (!attr_string) return 1;
			rc = xmlTextWriterWriteAttribute(writer, BAD_CAST "replicate", BAD_CAST attr_string);
			free(attr_string);
			if (rc < 0) return 1;
		}
		if (self->SimulatedProfiles) {
			for (int i = 0; i < self->num_SimulatedProfiles; i++) {
				rc = so_SimulationSubType_xml(self->SimulatedProfiles[i], writer, "SimulatedProfiles");
				if (rc != 0) return 1;
			}
		}
		if (self->IndivParameters) {
			for (int i = 0; i < self->num_IndivParameters; i++) {
				rc = so_SimulationSubType_xml(self->IndivParameters[i], writer, "IndivParameters");
				if (rc != 0) return 1;
			}
		}
		if (self->RandomEffects) {
			for (int i = 0; i < self->num_RandomEffects; i++) {
				rc = so_SimulationSubType_xml(self->RandomEffects[i], writer, "RandomEffects");
				if (rc != 0) return 1;
			}
		}
		if (self->Covariates) {
			for (int i = 0; i < self->num_Covariates; i++) {
				rc = so_SimulationSubType_xml(self->Covariates[i], writer, "Covariates");
				if (rc != 0) return 1;
			}
		}
		if (self->Regressors) {
			for (int i = 0; i < self->num_Regressors; i++) {
				rc = so_SimulationSubType_xml(self->Regressors[i], writer, "Regressors");
				if (rc != 0) return 1;
			}
		}
		if (self->PopulationParameters) {
			for (int i = 0; i < self->num_PopulationParameters; i++) {
				rc = so_SimulationSubType_xml(self->PopulationParameters[i], writer, "PopulationParameters");
				if (rc != 0) return 1;
			}
		}
		if (self->Dosing) {
			for (int i = 0; i < self->num_Dosing; i++) {
				rc = so_SimulationSubType_xml(self->Dosing[i], writer, "Dosing");
				if (rc != 0) return 1;
			}
		}
		if (self->RawResultsFile) {
			rc = so_ExternalFile_xml(self->RawResultsFile, writer, "RawResultsFile");
			if (rc != 0) return rc;
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_SimulationBlock_start_element(so_SimulationBlock *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_SimulatedProfiles) {
		int fail = so_SimulationSubType_start_element(self->SimulatedProfiles[self->num_SimulatedProfiles - 1], localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_IndivParameters) {
		int fail = so_SimulationSubType_start_element(self->IndivParameters[self->num_IndivParameters - 1], localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_RandomEffects) {
		int fail = so_SimulationSubType_start_element(self->RandomEffects[self->num_RandomEffects - 1], localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_Covariates) {
		int fail = so_SimulationSubType_start_element(self->Covariates[self->num_Covariates - 1], localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_Regressors) {
		int fail = so_SimulationSubType_start_element(self->Regressors[self->num_Regressors - 1], localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_PopulationParameters) {
		int fail = so_SimulationSubType_start_element(self->PopulationParameters[self->num_PopulationParameters - 1], localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_Dosing) {
		int fail = so_SimulationSubType_start_element(self->Dosing[self->num_Dosing - 1], localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_RawResultsFile) {
		int fail = so_ExternalFile_start_element(self->RawResultsFile, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "SimulatedProfiles") == 0) {
		so_SimulationSubType *SimulatedProfiles = so_SimulationSubType_new("SimulatedProfiles");
		if (!SimulatedProfiles) {
			return 1;
		}
		int fail = so_SimulationSubType_init_attributes(SimulatedProfiles, nb_attributes, attributes);
		if (fail) {
			so_SimulationSubType_free(SimulatedProfiles);
			return 1;
		}
		fail = so_SimulationBlock_add_SimulatedProfiles(self, SimulatedProfiles);
		if (fail) {
			so_SimulationSubType_free(SimulatedProfiles);
			return 1;
		}
		self->in_SimulatedProfiles = 1;
	} else if (strcmp(localname, "IndivParameters") == 0) {
		so_SimulationSubType *IndivParameters = so_SimulationSubType_new("IndivParameters");
		if (!IndivParameters) {
			return 1;
		}
		int fail = so_SimulationSubType_init_attributes(IndivParameters, nb_attributes, attributes);
		if (fail) {
			so_SimulationSubType_free(IndivParameters);
			return 1;
		}
		fail = so_SimulationBlock_add_IndivParameters(self, IndivParameters);
		if (fail) {
			so_SimulationSubType_free(IndivParameters);
			return 1;
		}
		self->in_IndivParameters = 1;
	} else if (strcmp(localname, "RandomEffects") == 0) {
		so_SimulationSubType *RandomEffects = so_SimulationSubType_new("RandomEffects");
		if (!RandomEffects) {
			return 1;
		}
		int fail = so_SimulationSubType_init_attributes(RandomEffects, nb_attributes, attributes);
		if (fail) {
			so_SimulationSubType_free(RandomEffects);
			return 1;
		}
		fail = so_SimulationBlock_add_RandomEffects(self, RandomEffects);
		if (fail) {
			so_SimulationSubType_free(RandomEffects);
			return 1;
		}
		self->in_RandomEffects = 1;
	} else if (strcmp(localname, "Covariates") == 0) {
		so_SimulationSubType *Covariates = so_SimulationSubType_new("Covariates");
		if (!Covariates) {
			return 1;
		}
		int fail = so_SimulationSubType_init_attributes(Covariates, nb_attributes, attributes);
		if (fail) {
			so_SimulationSubType_free(Covariates);
			return 1;
		}
		fail = so_SimulationBlock_add_Covariates(self, Covariates);
		if (fail) {
			so_SimulationSubType_free(Covariates);
			return 1;
		}
		self->in_Covariates = 1;
	} else if (strcmp(localname, "Regressors") == 0) {
		so_SimulationSubType *Regressors = so_SimulationSubType_new("Regressors");
		if (!Regressors) {
			return 1;
		}
		int fail = so_SimulationSubType_init_attributes(Regressors, nb_attributes, attributes);
		if (fail) {
			so_SimulationSubType_free(Regressors);
			return 1;
		}
		fail = so_SimulationBlock_add_Regressors(self, Regressors);
		if (fail) {
			so_SimulationSubType_free(Regressors);
			return 1;
		}
		self->in_Regressors = 1;
	} else if (strcmp(localname, "PopulationParameters") == 0) {
		so_SimulationSubType *PopulationParameters = so_SimulationSubType_new("PopulationParameters");
		if (!PopulationParameters) {
			return 1;
		}
		int fail = so_SimulationSubType_init_attributes(PopulationParameters, nb_attributes, attributes);
		if (fail) {
			so_SimulationSubType_free(PopulationParameters);
			return 1;
		}
		fail = so_SimulationBlock_add_PopulationParameters(self, PopulationParameters);
		if (fail) {
			so_SimulationSubType_free(PopulationParameters);
			return 1;
		}
		self->in_PopulationParameters = 1;
	} else if (strcmp(localname, "Dosing") == 0) {
		so_SimulationSubType *Dosing = so_SimulationSubType_new("Dosing");
		if (!Dosing) {
			return 1;
		}
		int fail = so_SimulationSubType_init_attributes(Dosing, nb_attributes, attributes);
		if (fail) {
			so_SimulationSubType_free(Dosing);
			return 1;
		}
		fail = so_SimulationBlock_add_Dosing(self, Dosing);
		if (fail) {
			so_SimulationSubType_free(Dosing);
			return 1;
		}
		self->in_Dosing = 1;
	} else if (strcmp(localname, "RawResultsFile") == 0) {
		so_ExternalFile *RawResultsFile = so_ExternalFile_new("RawResultsFile");
		if (!RawResultsFile) {
			return 1;
		}
		int fail = so_ExternalFile_init_attributes(RawResultsFile, nb_attributes, attributes);
		if (fail) {
			so_ExternalFile_free(RawResultsFile);
			return 1;
		}
		so_SimulationBlock_set_RawResultsFile(self, RawResultsFile);
		self->in_RawResultsFile = 1;
	}
	return 0;
}

void so_SimulationBlock_end_element(so_SimulationBlock *self, const char *localname)
{
	if (strcmp(localname, "SimulatedProfiles") == 0 && self->in_SimulatedProfiles) {
		self->in_SimulatedProfiles = 0;
	} else if (strcmp(localname, "IndivParameters") == 0 && self->in_IndivParameters) {
		self->in_IndivParameters = 0;
	} else if (strcmp(localname, "RandomEffects") == 0 && self->in_RandomEffects) {
		self->in_RandomEffects = 0;
	} else if (strcmp(localname, "Covariates") == 0 && self->in_Covariates) {
		self->in_Covariates = 0;
	} else if (strcmp(localname, "Regressors") == 0 && self->in_Regressors) {
		self->in_Regressors = 0;
	} else if (strcmp(localname, "PopulationParameters") == 0 && self->in_PopulationParameters) {
		self->in_PopulationParameters = 0;
	} else if (strcmp(localname, "Dosing") == 0 && self->in_Dosing) {
		self->in_Dosing = 0;
	} else if (strcmp(localname, "RawResultsFile") == 0 && self->in_RawResultsFile) {
		self->in_RawResultsFile = 0;
	} else if (self->in_SimulatedProfiles) {
		so_SimulationSubType_end_element(self->SimulatedProfiles[self->num_SimulatedProfiles - 1], localname);
	} else if (self->in_IndivParameters) {
		so_SimulationSubType_end_element(self->IndivParameters[self->num_IndivParameters - 1], localname);
	} else if (self->in_RandomEffects) {
		so_SimulationSubType_end_element(self->RandomEffects[self->num_RandomEffects - 1], localname);
	} else if (self->in_Covariates) {
		so_SimulationSubType_end_element(self->Covariates[self->num_Covariates - 1], localname);
	} else if (self->in_Regressors) {
		so_SimulationSubType_end_element(self->Regressors[self->num_Regressors - 1], localname);
	} else if (self->in_PopulationParameters) {
		so_SimulationSubType_end_element(self->PopulationParameters[self->num_PopulationParameters - 1], localname);
	} else if (self->in_Dosing) {
		so_SimulationSubType_end_element(self->Dosing[self->num_Dosing - 1], localname);
	} else if (self->in_RawResultsFile) {
		so_ExternalFile_end_element(self->RawResultsFile, localname);
	}
}

int so_SimulationBlock_characters(so_SimulationBlock *self, const char *ch, int len)
{
	if (self->in_SimulatedProfiles) {
		int fail = so_SimulationSubType_characters(self->SimulatedProfiles[self->num_SimulatedProfiles - 1], ch, len);
		if (fail) return 1;
	} else if (self->in_IndivParameters) {
		int fail = so_SimulationSubType_characters(self->IndivParameters[self->num_IndivParameters - 1], ch, len);
		if (fail) return 1;
	} else if (self->in_RandomEffects) {
		int fail = so_SimulationSubType_characters(self->RandomEffects[self->num_RandomEffects - 1], ch, len);
		if (fail) return 1;
	} else if (self->in_Covariates) {
		int fail = so_SimulationSubType_characters(self->Covariates[self->num_Covariates - 1], ch, len);
		if (fail) return 1;
	} else if (self->in_Regressors) {
		int fail = so_SimulationSubType_characters(self->Regressors[self->num_Regressors - 1], ch, len);
		if (fail) return 1;
	} else if (self->in_PopulationParameters) {
		int fail = so_SimulationSubType_characters(self->PopulationParameters[self->num_PopulationParameters - 1], ch, len);
		if (fail) return 1;
	} else if (self->in_Dosing) {
		int fail = so_SimulationSubType_characters(self->Dosing[self->num_Dosing - 1], ch, len);
		if (fail) return 1;
	} else if (self->in_RawResultsFile) {
		int fail = so_ExternalFile_characters(self->RawResultsFile, ch, len);
		if (fail) return 1;
	}
	return 0;
}

int so_SimulationBlock_init_attributes(so_SimulationBlock *self, int nb_attributes, const char **attributes)
{
	unsigned int index = 0;
	for (int i = 0; i < nb_attributes; i++, index += 5) {
		const char *localname = attributes[index];
		const char *valueBegin = attributes[index + 3];
		const char *valueEnd = attributes[index + 4];

		if (strcmp(localname, "replicate") == 0) {
			char *final_char = (char *) valueEnd;
			char end_char = *final_char;
			*final_char = '\0';
			self->replicate_number = pharmml_string_to_int(valueBegin);
			self->replicate = &(self->replicate_number);
			*final_char = end_char;
		}
	}
	return 0;
}
