/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/OtherMethod_PPE.h>
#include <so/private/OtherMethod_PPE.h>

so_OtherMethod_PPE *so_OtherMethod_PPE_new()
{
	so_OtherMethod_PPE *object = calloc(sizeof(so_OtherMethod_PPE), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_OtherMethod_PPE *so_OtherMethod_PPE_copy(so_OtherMethod_PPE *self)
{
	so_OtherMethod_PPE *dest = so_OtherMethod_PPE_new();
	if (dest) {
		if (self->CovarianceMatrix) {
			dest->CovarianceMatrix = so_Matrix_copy(self->CovarianceMatrix);
			if (!dest->CovarianceMatrix) {
				so_OtherMethod_PPE_free(dest);
				return NULL;
			}
		}
		if (self->CorrelationMatrix) {
			dest->CorrelationMatrix = so_Matrix_copy(self->CorrelationMatrix);
			if (!dest->CorrelationMatrix) {
				so_OtherMethod_PPE_free(dest);
				return NULL;
			}
		}
		if (self->StandardDeviation) {
			dest->StandardDeviation = so_Table_copy(self->StandardDeviation);
			if (!dest->StandardDeviation) {
				so_OtherMethod_PPE_free(dest);
				return NULL;
			}
		}
		if (self->StandardError) {
			dest->StandardError = so_Table_copy(self->StandardError);
			if (!dest->StandardError) {
				so_OtherMethod_PPE_free(dest);
				return NULL;
			}
		}
		if (self->AsymptoticCI) {
			dest->AsymptoticCI = so_Table_copy(self->AsymptoticCI);
			if (!dest->AsymptoticCI) {
				so_OtherMethod_PPE_free(dest);
				return NULL;
			}
		}
		if (self->PercentilesCI) {
			dest->PercentilesCI = so_Table_copy(self->PercentilesCI);
			if (!dest->PercentilesCI) {
				so_OtherMethod_PPE_free(dest);
				return NULL;
			}
		}
	}

	return dest;
}

void so_OtherMethod_PPE_free(so_OtherMethod_PPE *self)
{
	if (self) {
		so_Matrix_unref(self->CovarianceMatrix);
		so_Matrix_unref(self->CorrelationMatrix);
		so_Table_unref(self->StandardDeviation);
		so_Table_unref(self->StandardError);
		so_Table_unref(self->AsymptoticCI);
		so_Table_unref(self->PercentilesCI);
		free(self);
	}
}

void so_OtherMethod_PPE_ref(so_OtherMethod_PPE *self)
{
	self->reference_count++;
}

void so_OtherMethod_PPE_unref(so_OtherMethod_PPE *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_OtherMethod_PPE_free(self);
		}
	}
}

so_Matrix *so_OtherMethod_PPE_get_CovarianceMatrix(so_OtherMethod_PPE *self)
{
	return self->CovarianceMatrix;
}

so_Matrix *so_OtherMethod_PPE_get_CorrelationMatrix(so_OtherMethod_PPE *self)
{
	return self->CorrelationMatrix;
}

so_Table *so_OtherMethod_PPE_get_StandardDeviation(so_OtherMethod_PPE *self)
{
	return self->StandardDeviation;
}

so_Table *so_OtherMethod_PPE_get_StandardError(so_OtherMethod_PPE *self)
{
	return self->StandardError;
}

so_Table *so_OtherMethod_PPE_get_AsymptoticCI(so_OtherMethod_PPE *self)
{
	return self->AsymptoticCI;
}

so_Table *so_OtherMethod_PPE_get_PercentilesCI(so_OtherMethod_PPE *self)
{
	return self->PercentilesCI;
}

void so_OtherMethod_PPE_set_CovarianceMatrix(so_OtherMethod_PPE *self, so_Matrix *value)
{
	so_Matrix_unref(self->CovarianceMatrix);
	self->CovarianceMatrix = value;
}

void so_OtherMethod_PPE_set_CorrelationMatrix(so_OtherMethod_PPE *self, so_Matrix *value)
{
	so_Matrix_unref(self->CorrelationMatrix);
	self->CorrelationMatrix = value;
}

void so_OtherMethod_PPE_set_StandardDeviation(so_OtherMethod_PPE *self, so_Table *value)
{
	so_Table_unref(self->StandardDeviation);
	self->StandardDeviation = value;
}

void so_OtherMethod_PPE_set_StandardError(so_OtherMethod_PPE *self, so_Table *value)
{
	so_Table_unref(self->StandardError);
	self->StandardError = value;
}

void so_OtherMethod_PPE_set_AsymptoticCI(so_OtherMethod_PPE *self, so_Table *value)
{
	so_Table_unref(self->AsymptoticCI);
	self->AsymptoticCI = value;
}

void so_OtherMethod_PPE_set_PercentilesCI(so_OtherMethod_PPE *self, so_Table *value)
{
	so_Table_unref(self->PercentilesCI);
	self->PercentilesCI = value;
}

so_Matrix *so_OtherMethod_PPE_create_CovarianceMatrix(so_OtherMethod_PPE *self)
{
	so_Matrix *obj = so_Matrix_new("CovarianceMatrix");
	if (obj) {
		self->CovarianceMatrix = obj;
	}
	return obj;
}

so_Matrix *so_OtherMethod_PPE_create_CorrelationMatrix(so_OtherMethod_PPE *self)
{
	so_Matrix *obj = so_Matrix_new("CorrelationMatrix");
	if (obj) {
		self->CorrelationMatrix = obj;
	}
	return obj;
}

so_Table *so_OtherMethod_PPE_create_StandardDeviation(so_OtherMethod_PPE *self)
{
	so_Table *obj = so_Table_new("StandardDeviation");
	if (obj) {
		self->StandardDeviation = obj;
	}
	return obj;
}

so_Table *so_OtherMethod_PPE_create_StandardError(so_OtherMethod_PPE *self)
{
	so_Table *obj = so_Table_new("StandardError");
	if (obj) {
		self->StandardError = obj;
	}
	return obj;
}

so_Table *so_OtherMethod_PPE_create_AsymptoticCI(so_OtherMethod_PPE *self)
{
	so_Table *obj = so_Table_new("AsymptoticCI");
	if (obj) {
		self->AsymptoticCI = obj;
	}
	return obj;
}

so_Table *so_OtherMethod_PPE_create_PercentilesCI(so_OtherMethod_PPE *self)
{
	so_Table *obj = so_Table_new("PercentilesCI");
	if (obj) {
		self->PercentilesCI = obj;
	}
	return obj;
}

int so_OtherMethod_PPE_xml(so_OtherMethod_PPE *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->CovarianceMatrix || self->CorrelationMatrix || self->StandardDeviation || self->StandardError || self->AsymptoticCI || self->PercentilesCI) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "OtherMethod_PPE");
		if (rc < 0) return 1;
		if (self->CovarianceMatrix) {
			rc = so_Matrix_xml(self->CovarianceMatrix, writer, "CovarianceMatrix");
			if (rc != 0) return rc;
		}
		if (self->CorrelationMatrix) {
			rc = so_Matrix_xml(self->CorrelationMatrix, writer, "CorrelationMatrix");
			if (rc != 0) return rc;
		}
		if (self->StandardDeviation) {
			rc = so_Table_xml(self->StandardDeviation, writer, "StandardDeviation");
			if (rc != 0) return rc;
		}
		if (self->StandardError) {
			rc = so_Table_xml(self->StandardError, writer, "StandardError");
			if (rc != 0) return rc;
		}
		if (self->AsymptoticCI) {
			rc = so_Table_xml(self->AsymptoticCI, writer, "AsymptoticCI");
			if (rc != 0) return rc;
		}
		if (self->PercentilesCI) {
			rc = so_Table_xml(self->PercentilesCI, writer, "PercentilesCI");
			if (rc != 0) return rc;
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_OtherMethod_PPE_start_element(so_OtherMethod_PPE *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_CovarianceMatrix) {
		int fail = so_Matrix_start_element(self->CovarianceMatrix, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_CorrelationMatrix) {
		int fail = so_Matrix_start_element(self->CorrelationMatrix, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_StandardDeviation) {
		int fail = so_Table_start_element(self->StandardDeviation, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_StandardError) {
		int fail = so_Table_start_element(self->StandardError, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_AsymptoticCI) {
		int fail = so_Table_start_element(self->AsymptoticCI, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_PercentilesCI) {
		int fail = so_Table_start_element(self->PercentilesCI, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "CovarianceMatrix") == 0) {
		so_Matrix *CovarianceMatrix = so_OtherMethod_PPE_create_CovarianceMatrix(self);
		if (!CovarianceMatrix) {
			return 1;
		}
		self->in_CovarianceMatrix = 1;
	} else if (strcmp(localname, "CorrelationMatrix") == 0) {
		so_Matrix *CorrelationMatrix = so_OtherMethod_PPE_create_CorrelationMatrix(self);
		if (!CorrelationMatrix) {
			return 1;
		}
		self->in_CorrelationMatrix = 1;
	} else if (strcmp(localname, "StandardDeviation") == 0) {
		so_Table *StandardDeviation = so_OtherMethod_PPE_create_StandardDeviation(self);
		if (!StandardDeviation) {
			return 1;
		}
		self->in_StandardDeviation = 1;
	} else if (strcmp(localname, "StandardError") == 0) {
		so_Table *StandardError = so_OtherMethod_PPE_create_StandardError(self);
		if (!StandardError) {
			return 1;
		}
		self->in_StandardError = 1;
	} else if (strcmp(localname, "AsymptoticCI") == 0) {
		so_Table *AsymptoticCI = so_OtherMethod_PPE_create_AsymptoticCI(self);
		if (!AsymptoticCI) {
			return 1;
		}
		self->in_AsymptoticCI = 1;
	} else if (strcmp(localname, "PercentilesCI") == 0) {
		so_Table *PercentilesCI = so_OtherMethod_PPE_create_PercentilesCI(self);
		if (!PercentilesCI) {
			return 1;
		}
		self->in_PercentilesCI = 1;
	}
	return 0;
}

void so_OtherMethod_PPE_end_element(so_OtherMethod_PPE *self, const char *localname)
{
	if (strcmp(localname, "CovarianceMatrix") == 0 && self->in_CovarianceMatrix) {
		self->in_CovarianceMatrix = 0;
	} else if (strcmp(localname, "CorrelationMatrix") == 0 && self->in_CorrelationMatrix) {
		self->in_CorrelationMatrix = 0;
	} else if (strcmp(localname, "StandardDeviation") == 0 && self->in_StandardDeviation) {
		self->in_StandardDeviation = 0;
	} else if (strcmp(localname, "StandardError") == 0 && self->in_StandardError) {
		self->in_StandardError = 0;
	} else if (strcmp(localname, "AsymptoticCI") == 0 && self->in_AsymptoticCI) {
		self->in_AsymptoticCI = 0;
	} else if (strcmp(localname, "PercentilesCI") == 0 && self->in_PercentilesCI) {
		self->in_PercentilesCI = 0;
	} else if (self->in_CovarianceMatrix) {
		so_Matrix_end_element(self->CovarianceMatrix, localname);
	} else if (self->in_CorrelationMatrix) {
		so_Matrix_end_element(self->CorrelationMatrix, localname);
	} else if (self->in_StandardDeviation) {
		so_Table_end_element(self->StandardDeviation, localname);
	} else if (self->in_StandardError) {
		so_Table_end_element(self->StandardError, localname);
	} else if (self->in_AsymptoticCI) {
		so_Table_end_element(self->AsymptoticCI, localname);
	} else if (self->in_PercentilesCI) {
		so_Table_end_element(self->PercentilesCI, localname);
	}
}

int so_OtherMethod_PPE_characters(so_OtherMethod_PPE *self, const char *ch, int len)
{
	if (self->in_CovarianceMatrix) {
		int fail = so_Matrix_characters(self->CovarianceMatrix, ch, len);
		if (fail) return 1;
	} else if (self->in_CorrelationMatrix) {
		int fail = so_Matrix_characters(self->CorrelationMatrix, ch, len);
		if (fail) return 1;
	} else if (self->in_StandardDeviation) {
		int fail = so_Table_characters(self->StandardDeviation, ch, len);
		if (fail) return 1;
	} else if (self->in_StandardError) {
		int fail = so_Table_characters(self->StandardError, ch, len);
		if (fail) return 1;
	} else if (self->in_AsymptoticCI) {
		int fail = so_Table_characters(self->AsymptoticCI, ch, len);
		if (fail) return 1;
	} else if (self->in_PercentilesCI) {
		int fail = so_Table_characters(self->PercentilesCI, ch, len);
		if (fail) return 1;
	}
	return 0;
}
