/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_OPTIMALDESIGN_H
#define _SO_OPTIMALDESIGN_H

#include <so/OptimalDesignBlock.h>

/** \struct so_OptimalDesign
	 \brief A structure representing an SO/SOBlock/OptimalDesign element
*/
typedef struct so_OptimalDesign so_OptimalDesign;

/** \memberof so_OptimalDesign
 * Create a new empty so_OptimalDesign structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_OptimalDesign_copy, so_OptimalDesign_free
 */
so_OptimalDesign *so_OptimalDesign_new();
/** \memberof so_OptimalDesign
 * Create a copy of a so_OptimalDesign structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_OptimalDesign_new
 */
so_OptimalDesign *so_OptimalDesign_copy(so_OptimalDesign *self);
/** \memberof so_OptimalDesign
 * Free all memory associated with a so_OptimalDesign structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_OptimalDesign_new
 */
void so_OptimalDesign_free(so_OptimalDesign *self);
void so_OptimalDesign_ref(so_OptimalDesign *self);
void so_OptimalDesign_unref(so_OptimalDesign *self);
/** \memberof so_OptimalDesign
 * Get the value of the type attribute
 * \param self - pointer to a so_OptimalDesign
 * \return A pointer to the attribute value
 * \sa so_OptimalDesign_set_type
 */
char *so_OptimalDesign_get_type(so_OptimalDesign *self);
/** \memberof so_OptimalDesign
 * Set the value of the type attribute
 * \param self - pointer to a so_OptimalDesign
 * \param value - A pointer to the attribute value
 * \return 0 for success
 * \sa so_OptimalDesign_get_type
 */
int so_OptimalDesign_set_type(so_OptimalDesign *self, char *value);
/** \memberof so_OptimalDesign
 * Get the OptimalDesignBlock element
 * \param self - pointer to a so_OptimalDesign
 * \param number - An index to the specific element
 * \return A pointer to the structure representing the OptimalDesignBlock element
 * \sa so_OptimalDesign_set_OptimalDesignBlock
 */
so_OptimalDesignBlock *so_OptimalDesign_get_OptimalDesignBlock(so_OptimalDesign *self, int number);
/** \memberof so_OptimalDesign
 * Get the number of OptimalDesignBlock currently contained in the OptimalDesign structure
 * \param self - pointer to a so_OptimalDesign
 * \return The number of OptimalDesignBlocks
 */
int so_OptimalDesign_get_number_of_OptimalDesignBlock(so_OptimalDesign *self);
/** \memberof so_OptimalDesign
 * Create a new OptimalDesignBlock element and insert it into the so_OptimalDesign
 * \param self - pointer to a so_OptimalDesign
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_OptimalDesignBlock *so_OptimalDesign_create_OptimalDesignBlock(so_OptimalDesign *self);
int so_OptimalDesign_add_OptimalDesignBlock(so_OptimalDesign *self, so_OptimalDesignBlock *child);
int so_OptimalDesign_remove_OptimalDesignBlock(so_OptimalDesign *self, int index);

#endif
