/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_DIAGNOSTICSTRUCTURALMODEL_H
#define _SO_DIAGNOSTICSTRUCTURALMODEL_H

#include <so/Table.h>

/** \struct so_DiagnosticStructuralModel
	 \brief A structure representing an SO/SOBlock/ModelDiagnostic/DiagnosticStructuralModel element
*/
typedef struct so_DiagnosticStructuralModel so_DiagnosticStructuralModel;

/** \memberof so_DiagnosticStructuralModel
 * Create a new empty so_DiagnosticStructuralModel structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_DiagnosticStructuralModel_copy, so_DiagnosticStructuralModel_free
 */
so_DiagnosticStructuralModel *so_DiagnosticStructuralModel_new();
/** \memberof so_DiagnosticStructuralModel
 * Create a copy of a so_DiagnosticStructuralModel structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_DiagnosticStructuralModel_new
 */
so_DiagnosticStructuralModel *so_DiagnosticStructuralModel_copy(so_DiagnosticStructuralModel *self);
/** \memberof so_DiagnosticStructuralModel
 * Free all memory associated with a so_DiagnosticStructuralModel structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_DiagnosticStructuralModel_new
 */
void so_DiagnosticStructuralModel_free(so_DiagnosticStructuralModel *self);
void so_DiagnosticStructuralModel_ref(so_DiagnosticStructuralModel *self);
void so_DiagnosticStructuralModel_unref(so_DiagnosticStructuralModel *self);
/** \memberof so_DiagnosticStructuralModel
 * Get the IndivObservationPrediction element
 * \param self - pointer to a so_DiagnosticStructuralModel
 * \return A pointer to the structure representing the IndivObservationPrediction element
 * \sa so_DiagnosticStructuralModel_set_IndivObservationPrediction
 */
so_Table *so_DiagnosticStructuralModel_get_IndivObservationPrediction(so_DiagnosticStructuralModel *self);
/** \memberof so_DiagnosticStructuralModel
 * Get the VPC element
 * \param self - pointer to a so_DiagnosticStructuralModel
 * \return A pointer to the structure representing the VPC element
 * \sa so_DiagnosticStructuralModel_set_VPC
 */
so_Table *so_DiagnosticStructuralModel_get_VPC(so_DiagnosticStructuralModel *self);
/** \memberof so_DiagnosticStructuralModel
 * Set the IndivObservationPrediction element
 * \param self - pointer to a so_DiagnosticStructuralModel
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_DiagnosticStructuralModel_get_IndivObservationPrediction
 */
void so_DiagnosticStructuralModel_set_IndivObservationPrediction(so_DiagnosticStructuralModel *self, so_Table *value);
/** \memberof so_DiagnosticStructuralModel
 * Set the VPC element
 * \param self - pointer to a so_DiagnosticStructuralModel
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_DiagnosticStructuralModel_get_VPC
 */
void so_DiagnosticStructuralModel_set_VPC(so_DiagnosticStructuralModel *self, so_Table *value);
/** \memberof so_DiagnosticStructuralModel
 * Create a new IndivObservationPrediction element and insert it into the so_DiagnosticStructuralModel
 * \param self - pointer to a so_DiagnosticStructuralModel
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_DiagnosticStructuralModel_create_IndivObservationPrediction(so_DiagnosticStructuralModel *self);
/** \memberof so_DiagnosticStructuralModel
 * Create a new VPC element and insert it into the so_DiagnosticStructuralModel
 * \param self - pointer to a so_DiagnosticStructuralModel
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_DiagnosticStructuralModel_create_VPC(so_DiagnosticStructuralModel *self);

#endif
