/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#include <R.h>
#include <Rdefines.h>
#include <so.h>
#include "soc.h"

SEXP r_so_Simulation_new()
{
	so_Simulation *obj = so_Simulation_new();
	if (!obj) {
		error("Failed to create so_Simulation object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_Simulation_copy(SEXP self)
{
	so_Simulation *obj = so_Simulation_copy(R_ExternalPtrAddr(self));
	if (!obj) {
		error("Failed to copy so_Simulation object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_Simulation_free(SEXP self)
{
	so_Simulation_free(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_Simulation_ref(SEXP self)
{
	so_Simulation_ref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_Simulation_unref(SEXP self)
{
	so_Simulation_unref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_Simulation_get_SimulationBlock(SEXP self, SEXP index)
{
	so_SimulationBlock *child = so_Simulation_get_SimulationBlock(R_ExternalPtrAddr(self), INTEGER(index)[0]);
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_Simulation_get_number_of_SimulationBlock(SEXP self)
{
	int number = so_Simulation_get_number_of_SimulationBlock(R_ExternalPtrAddr(self));
	SEXP r_int = PROTECT(NEW_INTEGER(1));
	INTEGER(r_int)[0] = number;
	UNPROTECT(1);
	return r_int;
}
SEXP r_so_Simulation_add_SimulationBlock(SEXP self, SEXP child)
{
	int fail = so_Simulation_add_SimulationBlock(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	if (fail) {
		error("Failed to add SimulationBlock to Simulation");
	}
	return(R_NilValue);
}
SEXP r_so_Simulation_remove_SimulationBlock(SEXP self, SEXP index)
{
	int fail = so_Simulation_remove_SimulationBlock(R_ExternalPtrAddr(self), INTEGER(index)[0]);
	if (fail) {
		error("Failed to remove SimulationBlock from Simulation");
	}
	return(R_NilValue);
}
SEXP r_so_Simulation_create_SimulationBlock(SEXP self)
{
	so_SimulationBlock *child = so_Simulation_create_SimulationBlock(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

