/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/PrecisionIndividualEstimates.h>
#include <so/private/PrecisionIndividualEstimates.h>

so_PrecisionIndividualEstimates *so_PrecisionIndividualEstimates_new()
{
	so_PrecisionIndividualEstimates *object = calloc(sizeof(so_PrecisionIndividualEstimates), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_PrecisionIndividualEstimates *so_PrecisionIndividualEstimates_copy(so_PrecisionIndividualEstimates *self)
{
	so_PrecisionIndividualEstimates *dest = so_PrecisionIndividualEstimates_new();
	if (dest) {
		if (self->StandardDeviation) {
			dest->StandardDeviation = so_Table_copy(self->StandardDeviation);
			if (!dest->StandardDeviation) {
				so_PrecisionIndividualEstimates_free(dest);
				return NULL;
			}
		}
		if (self->PercentilesCI) {
			dest->PercentilesCI = so_Table_copy(self->PercentilesCI);
			if (!dest->PercentilesCI) {
				so_PrecisionIndividualEstimates_free(dest);
				return NULL;
			}
		}
	}

	return dest;
}

void so_PrecisionIndividualEstimates_free(so_PrecisionIndividualEstimates *self)
{
	if (self) {
		so_Table_unref(self->StandardDeviation);
		so_Table_unref(self->PercentilesCI);
		free(self);
	}
}

void so_PrecisionIndividualEstimates_ref(so_PrecisionIndividualEstimates *self)
{
	self->reference_count++;
}

void so_PrecisionIndividualEstimates_unref(so_PrecisionIndividualEstimates *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_PrecisionIndividualEstimates_free(self);
		}
	}
}

so_Table *so_PrecisionIndividualEstimates_get_StandardDeviation(so_PrecisionIndividualEstimates *self)
{
	return self->StandardDeviation;
}

so_Table *so_PrecisionIndividualEstimates_get_PercentilesCI(so_PrecisionIndividualEstimates *self)
{
	return self->PercentilesCI;
}

void so_PrecisionIndividualEstimates_set_StandardDeviation(so_PrecisionIndividualEstimates *self, so_Table *value)
{
	so_Table_unref(self->StandardDeviation);
	self->StandardDeviation = value;
}

void so_PrecisionIndividualEstimates_set_PercentilesCI(so_PrecisionIndividualEstimates *self, so_Table *value)
{
	so_Table_unref(self->PercentilesCI);
	self->PercentilesCI = value;
}

so_Table *so_PrecisionIndividualEstimates_create_StandardDeviation(so_PrecisionIndividualEstimates *self)
{
	so_Table *obj = so_Table_new("StandardDeviation");
	if (obj) {
		self->StandardDeviation = obj;
	}
	return obj;
}

so_Table *so_PrecisionIndividualEstimates_create_PercentilesCI(so_PrecisionIndividualEstimates *self)
{
	so_Table *obj = so_Table_new("PercentilesCI");
	if (obj) {
		self->PercentilesCI = obj;
	}
	return obj;
}

int so_PrecisionIndividualEstimates_xml(so_PrecisionIndividualEstimates *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->StandardDeviation || self->PercentilesCI) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "PrecisionIndividualEstimates");
		if (rc < 0) return 1;
		if (self->StandardDeviation) {
			rc = so_Table_xml(self->StandardDeviation, writer, "StandardDeviation");
			if (rc != 0) return rc;
		}
		if (self->PercentilesCI) {
			rc = so_Table_xml(self->PercentilesCI, writer, "PercentilesCI");
			if (rc != 0) return rc;
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_PrecisionIndividualEstimates_start_element(so_PrecisionIndividualEstimates *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_StandardDeviation) {
		int fail = so_Table_start_element(self->StandardDeviation, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_PercentilesCI) {
		int fail = so_Table_start_element(self->PercentilesCI, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "StandardDeviation") == 0) {
		so_Table *StandardDeviation = so_PrecisionIndividualEstimates_create_StandardDeviation(self);
		if (!StandardDeviation) {
			return 1;
		}
		self->in_StandardDeviation = 1;
	} else if (strcmp(localname, "PercentilesCI") == 0) {
		so_Table *PercentilesCI = so_PrecisionIndividualEstimates_create_PercentilesCI(self);
		if (!PercentilesCI) {
			return 1;
		}
		self->in_PercentilesCI = 1;
	}
	return 0;
}

void so_PrecisionIndividualEstimates_end_element(so_PrecisionIndividualEstimates *self, const char *localname)
{
	if (strcmp(localname, "StandardDeviation") == 0 && self->in_StandardDeviation) {
		self->in_StandardDeviation = 0;
	} else if (strcmp(localname, "PercentilesCI") == 0 && self->in_PercentilesCI) {
		self->in_PercentilesCI = 0;
	} else if (self->in_StandardDeviation) {
		so_Table_end_element(self->StandardDeviation, localname);
	} else if (self->in_PercentilesCI) {
		so_Table_end_element(self->PercentilesCI, localname);
	}
}

int so_PrecisionIndividualEstimates_characters(so_PrecisionIndividualEstimates *self, const char *ch, int len)
{
	if (self->in_StandardDeviation) {
		int fail = so_Table_characters(self->StandardDeviation, ch, len);
		if (fail) return 1;
	} else if (self->in_PercentilesCI) {
		int fail = so_Table_characters(self->PercentilesCI, ch, len);
		if (fail) return 1;
	}
	return 0;
}
