/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/PopulationEstimates.h>
#include <so/private/PopulationEstimates.h>

so_PopulationEstimates *so_PopulationEstimates_new()
{
	so_PopulationEstimates *object = calloc(sizeof(so_PopulationEstimates), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_PopulationEstimates *so_PopulationEstimates_copy(so_PopulationEstimates *self)
{
	so_PopulationEstimates *dest = so_PopulationEstimates_new();
	if (dest) {
		if (self->MLE) {
			dest->MLE = so_Table_copy(self->MLE);
			if (!dest->MLE) {
				so_PopulationEstimates_free(dest);
				return NULL;
			}
		}
		if (self->Bayesian) {
			dest->Bayesian = so_Bayesian_copy(self->Bayesian);
			if (!dest->Bayesian) {
				so_PopulationEstimates_free(dest);
				return NULL;
			}
		}
		if (self->OtherMethod) {
			dest->OtherMethod = so_OtherMethod_copy(self->OtherMethod);
			if (!dest->OtherMethod) {
				so_PopulationEstimates_free(dest);
				return NULL;
			}
		}
	}

	return dest;
}

void so_PopulationEstimates_free(so_PopulationEstimates *self)
{
	if (self) {
		so_Table_unref(self->MLE);
		so_Bayesian_unref(self->Bayesian);
		so_OtherMethod_unref(self->OtherMethod);
		free(self);
	}
}

void so_PopulationEstimates_ref(so_PopulationEstimates *self)
{
	self->reference_count++;
}

void so_PopulationEstimates_unref(so_PopulationEstimates *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_PopulationEstimates_free(self);
		}
	}
}

so_Table *so_PopulationEstimates_get_MLE(so_PopulationEstimates *self)
{
	return self->MLE;
}

so_Bayesian *so_PopulationEstimates_get_Bayesian(so_PopulationEstimates *self)
{
	return self->Bayesian;
}

so_OtherMethod *so_PopulationEstimates_get_OtherMethod(so_PopulationEstimates *self)
{
	return self->OtherMethod;
}

void so_PopulationEstimates_set_MLE(so_PopulationEstimates *self, so_Table *value)
{
	so_Table_unref(self->MLE);
	self->MLE = value;
}

void so_PopulationEstimates_set_Bayesian(so_PopulationEstimates *self, so_Bayesian *value)
{
	so_Bayesian_unref(self->Bayesian);
	self->Bayesian = value;
}

void so_PopulationEstimates_set_OtherMethod(so_PopulationEstimates *self, so_OtherMethod *value)
{
	so_OtherMethod_unref(self->OtherMethod);
	self->OtherMethod = value;
}

so_Table *so_PopulationEstimates_create_MLE(so_PopulationEstimates *self)
{
	so_Table *obj = so_Table_new("MLE");
	if (obj) {
		self->MLE = obj;
	}
	return obj;
}

so_Bayesian *so_PopulationEstimates_create_Bayesian(so_PopulationEstimates *self)
{
	so_Bayesian *obj = so_Bayesian_new();
	if (obj) {
		self->Bayesian = obj;
	}
	return obj;
}

so_OtherMethod *so_PopulationEstimates_create_OtherMethod(so_PopulationEstimates *self)
{
	so_OtherMethod *obj = so_OtherMethod_new();
	if (obj) {
		self->OtherMethod = obj;
	}
	return obj;
}

int so_PopulationEstimates_xml(so_PopulationEstimates *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->MLE || self->Bayesian || self->OtherMethod) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "PopulationEstimates");
		if (rc < 0) return 1;
		if (self->MLE) {
			rc = so_Table_xml(self->MLE, writer, "MLE");
			if (rc != 0) return rc;
		}
		if (self->Bayesian) {
			rc = so_Bayesian_xml(self->Bayesian, writer);
			if (rc != 0) return rc;
		}
		if (self->OtherMethod) {
			rc = so_OtherMethod_xml(self->OtherMethod, writer);
			if (rc != 0) return rc;
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_PopulationEstimates_start_element(so_PopulationEstimates *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_MLE) {
		int fail = so_Table_start_element(self->MLE, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_Bayesian) {
		int fail = so_Bayesian_start_element(self->Bayesian, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_OtherMethod) {
		int fail = so_OtherMethod_start_element(self->OtherMethod, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "MLE") == 0) {
		so_Table *MLE = so_PopulationEstimates_create_MLE(self);
		if (!MLE) {
			return 1;
		}
		self->in_MLE = 1;
	} else if (strcmp(localname, "Bayesian") == 0) {
		so_Bayesian *Bayesian = so_PopulationEstimates_create_Bayesian(self);
		if (!Bayesian) {
			return 1;
		}
		self->in_Bayesian = 1;
	} else if (strcmp(localname, "OtherMethod") == 0) {
		so_OtherMethod *OtherMethod = so_OtherMethod_new();
		if (!OtherMethod) {
			return 1;
		}
		int fail = so_OtherMethod_init_attributes(OtherMethod, nb_attributes, attributes);
		if (fail) {
			so_OtherMethod_free(OtherMethod);
			return 1;
		}
		so_PopulationEstimates_set_OtherMethod(self, OtherMethod);
		self->in_OtherMethod = 1;
	}
	return 0;
}

void so_PopulationEstimates_end_element(so_PopulationEstimates *self, const char *localname)
{
	if (strcmp(localname, "MLE") == 0 && self->in_MLE) {
		self->in_MLE = 0;
	} else if (strcmp(localname, "Bayesian") == 0 && self->in_Bayesian) {
		self->in_Bayesian = 0;
	} else if (strcmp(localname, "OtherMethod") == 0 && self->in_OtherMethod) {
		self->in_OtherMethod = 0;
	} else if (self->in_MLE) {
		so_Table_end_element(self->MLE, localname);
	} else if (self->in_Bayesian) {
		so_Bayesian_end_element(self->Bayesian, localname);
	} else if (self->in_OtherMethod) {
		so_OtherMethod_end_element(self->OtherMethod, localname);
	}
}

int so_PopulationEstimates_characters(so_PopulationEstimates *self, const char *ch, int len)
{
	if (self->in_MLE) {
		int fail = so_Table_characters(self->MLE, ch, len);
		if (fail) return 1;
	} else if (self->in_Bayesian) {
		int fail = so_Bayesian_characters(self->Bayesian, ch, len);
		if (fail) return 1;
	} else if (self->in_OtherMethod) {
		int fail = so_OtherMethod_characters(self->OtherMethod, ch, len);
		if (fail) return 1;
	}
	return 0;
}
