% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogEvent.R
\name{print.LogEvent}
\alias{print.LogEvent}
\alias{format.LogEvent}
\title{Print or Format Logging Data}
\usage{
\method{print}{LogEvent}(
  x,
  fmt = "\%L [\%t] \%m  \%f",
  timestamp_fmt = "\%Y-\%m-\%d \%H:\%M:\%S",
  colors = getOption("lgr.colors"),
  log_levels = getOption("lgr.log_levels"),
  pad_levels = "right",
  ...
)

\method{format}{LogEvent}(
  x,
  fmt = "\%L [\%t] \%m  \%f",
  timestamp_fmt = "\%Y-\%m-\%d \%H:\%M:\%S",
  colors = NULL,
  log_levels = getOption("lgr.log_levels"),
  pad_levels = "right",
  ...
)
}
\arguments{
\item{x}{a \link{LogEvent}}

\item{fmt}{A \code{character} scalar that may contain any of the tokens listed
bellow in the section Format Tokens.}

\item{timestamp_fmt}{see \code{\link[=format.POSIXct]{format.POSIXct()}}}

\item{colors}{A \code{list} of \code{functions} that will be used to color the
log levels (likely from \link[crayon:crayon]{crayon::crayon}).}

\item{log_levels}{named \code{integer} vector of valid log levels}

\item{pad_levels}{\code{right}, \code{left} or \code{NULL}. Whether or not to pad the log
level names to the same width on the left or right side, or not at all.}

\item{...}{ignored}
}
\value{
\code{x} for \code{print()} and a \code{character} scalar for \code{format()}
}
\description{
Print or Format Logging Data
}
\section{Format Tokens}{

\describe{
\item{\verb{\%t}}{The timestamp of the message, formatted according to
\code{timestamp_fmt})}
\item{\verb{\%l}}{the log level, lowercase \code{character} representation}
\item{\verb{\%L}}{the log level, uppercase \code{character} representation}
\item{\verb{\%k}}{the log level, first letter of lowercase \code{character} representation}
\item{\verb{\%K}}{the log level, first letter of uppercase \code{character} representation}
\item{\verb{\%n}}{the log level, \code{integer} representation}
\item{\verb{\%p}}{the PID (process ID). Useful when logging code that uses
multiple threads.}
\item{\verb{\%c}}{the calling function}
\item{\verb{\%m}}{the log message}
\item{\verb{\%f}}{all custom fields of \code{x} in a pseudo-JSON like format that is
optimized for human readability and console output}
\item{\verb{\%j}}{all custom fields of \code{x} in proper JSON. This requires that you
have \strong{jsonlite} installed and does not support colors as opposed to
\verb{\%f}
}
}
}

\examples{
# standard fields can be printed using special tokens
x <- LogEvent$new(
  level = 300, msg = "a test event", caller = "testfun()", logger = lgr
)
print(x)
print(x, fmt = c("\%t (\%p) \%c: \%n - \%m"))
print(x, colors = NULL)

# custom values
y <- LogEvent$new(
  level = 300, msg = "a gps track", logger = lgr,
  waypoints = 10, location = "Austria"
)

# default output with \%f
print(y)

# proper JSON output with \%j
if (requireNamespace("jsonlite")){
print(y, fmt = "\%L [\%t] \%m  \%j")
}

}
