% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layout.R
\name{LayoutFormat}
\alias{LayoutFormat}
\title{Format Log Events as Text}
\description{
Format a \link{LogEvent} as human readable text using \code{\link[=format.LogEvent]{format.LogEvent()}}, which
provides a quick and easy way to customize log messages. If you need
more control and flexibility, consider using \link{LayoutGlue} instead.
}
\section{Usage}{
\preformatted{
x <- x$new(fmt = "\%L [\%t] \%m", timestamp_fmt = "\%Y-\%m-\%d \%H:\%M:\%OS3", colors =
  NULL, pad_levels = "right")

x$format_event(event)
x$set_fmt(x)
x$set_timestamp_fmt(x)
x$set_colors(x)
x$set_pad_levels(x)
x$clone(deep = FALSE)

x$colors
x$fmt
x$pad_levels
x$timestamp_fmt

}
}

\section{Creating a New LayoutFormat}{


A new LayoutFormat is instantiated with \code{LayoutFormat$new()}. For a
description of the arguments to this function please refer to the Fields,
and the documentation of \code{\link[=format.LogEvent]{format.LogEvent()}}.
}

\section{Fields}{

\describe{
\item{\code{fmt}}{
a \code{character} scalar containing format tokens. See \code{\link[=format.LogEvent]{format.LogEvent()}}.}
\item{\code{timestamp_fmt}}{
a \code{character} scalar. See \code{\link[base:format.POSIXct]{base::format.POSIXct()}}}
\item{\code{colors}}{a named \code{list} of functions passed on on \code{\link[=format.LogEvent]{format.LogEvent()}}}
\item{\code{pad_levels}}{\code{right}, \code{left} or \code{NULL}. See \code{\link[=format.LogEvent]{format.LogEvent()}}}
}
}

\section{Format Tokens}{

This is the same list of format tokens as for \code{\link[=format.LogEvent]{format.LogEvent()}}


\describe{
\item{\code{\%t}}{The timestamp of the message, formatted according to
\code{timestamp_fmt})}
\item{\code{\%l}}{the log level, lowercase \code{character} representation}
\item{\code{\%L}}{the log level, uppercase \code{character} representation}
\item{\code{\%k}}{the log level, first letter of lowercase \code{character} representation}
\item{\code{\%K}}{the log level, first letter of uppercase \code{character} representation}
\item{\code{\%n}}{the log level, \code{integer} representation}
\item{\code{\%p}}{the PID (process ID). Useful when logging code that uses
multiple threads.}
\item{\code{\%c}}{the calling function}
\item{\code{\%m}}{the log message}
\item{\code{\%f}}{all custom fields of \code{x} in a pseudo-JSON like format that is
optimized for human readability and console output}
\item{\code{\%j}}{all custom fields of \code{x} in proper JSON. This requires that you
have \strong{jsonlite} installed and does not support colors as opposed to
\code{\%f}
}
}
}

\section{Methods}{


\describe{
\item{\code{format_event(event)}}{format a \link{LogEvent}}
}
}

\examples{
# setup a dummy LogEvent
event <- LogEvent$new(
  logger = Logger$new("dummy logger"),
  level = 200,
  timestamp = Sys.time(),
  caller = NA_character_,
  msg = "a test message"
)
lo <- LayoutFormat$new()
lo$format_event(event)

}
\seealso{
Other Layouts: \code{\link{LayoutDbi}},
  \code{\link{LayoutGlue}}, \code{\link{LayoutJson}},
  \code{\link{Layout}}
}
\concept{Layouts}
