% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R, R/methods-Prediction.R
\docType{class}
\name{GaussianPrediction-class}
\alias{GaussianPrediction-class}
\alias{GaussianPrediction}
\alias{show,GaussianPrediction-method}
\alias{component_names,GaussianPrediction-method}
\alias{num_components,GaussianPrediction-method}
\alias{num_paramsets,GaussianPrediction-method}
\alias{num_evalpoints,GaussianPrediction-method}
\title{An S4 class to represent analytically computed predictive distributions
(conditional on hyperparameters) of an additive GP model}
\usage{
\S4method{show}{GaussianPrediction}(object)

\S4method{component_names}{GaussianPrediction}(object)

\S4method{num_components}{GaussianPrediction}(object)

\S4method{num_paramsets}{GaussianPrediction}(object)

\S4method{num_evalpoints}{GaussianPrediction}(object)
}
\arguments{
\item{object}{\linkS4class{GaussianPrediction} object for which to apply a
class method.}
}
\description{
An S4 class to represent analytically computed predictive distributions
(conditional on hyperparameters) of an additive GP model
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Print a summary about the object.

\item \code{component_names}: Get names of components.

\item \code{num_components}: Get number of components.

\item \code{num_paramsets}: Get number of parameter combinations
(different parameter vectors) using which predictions were computed.

\item \code{num_evalpoints}: Get number of points where
predictions were computed.
}}

\section{Slots}{

\describe{
\item{\code{f_comp_mean}}{component means}

\item{\code{f_comp_std}}{component standard deviations}

\item{\code{f_mean}}{signal mean (on normalized scale)}

\item{\code{f_std}}{signal standard deviation (on normalized scale)}

\item{\code{y_mean}}{predictive mean (on original data scale)}

\item{\code{y_std}}{predictive standard deviation (on original data scale)}

\item{\code{x}}{a data frame of points (covariate values) where the
function posteriors or predictive distributions have been evaluated}
}}

\seealso{
\linkS4class{Prediction}
}
