\name{quantile.lgcpPredict}
\alias{quantile.lgcpPredict}
\title{quantile.lgcpPredict function}
\usage{
  \method{quantile}{lgcpPredict} (x, qt, tidx = NULL,
    fun = NULL, inWindow = x$xyt$window,
    crop2parentwindow = TRUE, startidx = 1,
    sampcount = NULL, ...)
}
\arguments{
  \item{x}{an object of class lgcpPredict}

  \item{qt}{a vector of the required quantiles}

  \item{tidx}{the index number of the the time interval of
  interest, default is the last time point.}

  \item{fun}{a 1-1 function (default the identity function)
  to be applied cell-wise to the grid. Must be able to
  evaluate sapply(vec,fun) for vectors vec.}

  \item{inWindow}{an observation owin window on which to
  compute the quantiles, can speed up calculation. Default
  is x$xyt$window.}

  \item{crop2parentwindow}{logical: whether to only compute
  the quantiles for cells inside x$xyt$window (the 'parent
  window')}

  \item{startidx}{optional starting sample index for
  computing quantiles. Default is 1.}

  \item{sampcount}{number of samples to include in
  computation of quantiles after startidx. Default is all}

  \item{...}{additional arguments}
}
\value{
  an array, the [,,i]th slice being the grid of cell-wise
  quantiles, qt[i], of fun(Y), where Y is the MCMC output
  dumped to disk.
}
\description{
  \bold{This function requires data to have been dumped to
  disk}: see \code{?dump2dir} and \code{?setoutput}. The
  routine \code{quantile.lgcpPredict} computes quantiles of
  functions of Y. For example, to get cell-wise quantiles
  of exceedance probabilities, set \code{fun=exp}. Since
  computign the quantiles is an expensive operation, the
  option to output the quantiles on a subregion of interest
  is also provided (by setting the argument
  \code{inWindow}, which has a sensible default).
}
\seealso{
  \link{lgcpPredict}, \link{dump2dir}, \link{setoutput},
  \link{plot.lgcpQuantiles}
}

