% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AggregateSpatialOnlyPlusParameters.R
\name{lgcpPredictAggregateSpatialPlusPars}
\alias{lgcpPredictAggregateSpatialPlusPars}
\title{lgcpPredictAggregateSpatialPlusPars function}
\usage{
lgcpPredictAggregateSpatialPlusPars(formula, spdf, Zmat = NULL,
  overlayInZmat = FALSE, model.priors, model.inits = lgcpInits(),
  spatial.covmodel, cellwidth = NULL, poisson.offset = NULL, mcmc.control,
  output.control = setoutput(), gradtrunc = Inf, ext = 2, Nfreq = 101,
  inclusion = "touching")
}
\arguments{
\item{formula}{a formula object of the form X ~ var1 + var2 etc. The name of the dependent variable must be "X". Only accepts 'simple' formulae, such as the example given.}

\item{spdf}{a SpatialPolygonsDataFrame object with variable "X", the event counts per region.}

\item{Zmat}{design matrix Z (see below) constructed with getZmat}

\item{overlayInZmat}{if the covariate information in Zmat also comes from spdf, set to TRUE to avoid replicating the overlay operations. Default is FALSE.}

\item{model.priors}{model priors, set using lgcpPrior}

\item{model.inits}{model initial values. The default is NULL, in which case lgcp will use the prior mean to initialise eta and beta will be initialised from an oversispersed glm fit to the data. Otherwise use lgcpInits to specify.}

\item{spatial.covmodel}{choice of spatial covariance function. See ?CovFunction}

\item{cellwidth}{the width of computational cells}

\item{poisson.offset}{A SpatialAtRisk object defining lambda (see below)}

\item{mcmc.control}{MCMC paramters, see ?mcmcpars}

\item{output.control}{output choice, see ?setoutput}

\item{gradtrunc}{truncation for gradient vector equal to H parameter Moller et al 1998 pp 473. Default is Inf, which means no gradient truncation, which seems to work in most settings.}

\item{ext}{integer multiple by which grid should be extended, default is 2. Generally this will not need to be altered, but if the spatial correlation decays slowly, increasing 'ext' may be necessary.}

\item{Nfreq}{the sampling frequency for the cell counts. Default is every 101 iterations.}

\item{inclusion}{criterion for cells being included into observation window. Either 'touching' or 'centroid'. The former, the default, includes all cells that touch the observation window, the latter includes all cells whose centroids are inside the observation window.}
}
\value{
an object of class lgcpPredictAggregateSpatialPlusParameters
}
\description{
A function to deliver fully Bayesian inference for the aggregated spatial log-Gaussian Cox process.\cr
}
\details{
See the vignette "Bayesian_lgcp" for examples of this code in use.\cr

In this case, we OBSERVE case counts in the regions of a SpatialPolygonsDataFrame; the counts are stored as a variable, X.
The model for the UNOBSERVED data, X(s), is as follows:\cr
\cr
X(s) ~ Poisson[R(s)]\cr
\cr
R(s) = C_A lambda(s) exp[Z(s)beta+Y(s)]\cr
\cr

Here X(s) is the number of events in the cell of the computational grid containing s, R(s) is the Poisson rate, 
C_A is the cell area, lambda(s) is a known offset, Z(s) is a vector of measured covariates and Y(s) is the 
latent Gaussian process on the computational grid. The other parameters in the model are beta, the covariate effects; 
and eta=[log(sigma),log(phi)], the parameters of the process Y on an appropriately transformed (in this case log) scale.

We recommend the user takes the following steps before running this method:

\enumerate{
   \item Compute approximate values of the parameters, eta, of the process Y using the function minimum.contrast. 
       These approximate values are used for two main reasons: (1) to help inform the size of the computational grid, since we 
       will need to use a cell width that enables us to capture the dependence properties of Y and (2) to help inform the 
       proposal kernel for the MCMC algorithm.
   \item Choose an appropriate grid on which to perform inference using the function chooseCellwidth; this will partly be determined 
       by the results of the first stage and partly by the available computational resource available to perform inference. 
   \item Using the function getpolyol, construct the computational grid and polygon overlays, as required. As this can be an expensive step, 
       we recommend that the user saves this object after it has been 
       constructed and in future reference to the data, reloads this object, rather than having to re-compute it (provided the 
       computational grid has not changed).
   \item Decide on which covariates are to play a part in the analysis and use the lgcp function getZmat to interpolate these 
       onto the computational grid. Note that having saved the results from the previous step, this is a relatively quick operation, 
       and allows the user to quickly construct different design matrices, Z, from different candidate models for the data
   \item If required, set up the population offset using SpatialAtRisk functions (see the vignette "Bayesian_lgcp"); specify the priors 
       using lgcpPrior; and if desired, the initial values for the MCMC, using the function lgcpInits.
   \item Run the MCMC algorithm and save the output to disk. We recommend dumping information to disk using the dump2dir function 
       in the output.control argument because it offers much greater flexibility in terms of MCMC diagnosis and post-processing.
   \item Perform post-processing analyses including MCMC diagnostic checks and produce summaries of the posterior expectations 
       we require for presentation. (see the vignette "Bayesian_lgcp" for further details). Functions of use in this step include
       traceplots, autocorr, parautocorr, ltar, parsummary, priorpost, postcov, textsummary, expectation, exceedProbs and lgcp:::expectation.lgcpPredict
}
}
\references{
\enumerate{
    \item Benjamin M. Taylor, Tilman M. Davies, Barry S. Rowlingson, Peter J. Diggle. Bayesian Inference and Data Augmentation Schemes for Spatial, Spatiotemporal and Multivariate Log-Gaussian Cox Processes in R. Submitted. 
    \item Benjamin M. Taylor, Tilman M. Davies, Barry S. Rowlingson, Peter J. Diggle (2013). Journal of Statistical Software, 52(4), 1-40. URL http://www.jstatsoft.org/v52/i04/
    \item Brix A, Diggle PJ (2001). Spatiotemporal Prediction for log-Gaussian Cox processes. Journal of the Royal Statistical Society, Series B, 63(4), 823-841.
    \item Diggle P, Rowlingson B, Su T (2005). Point Process Methodology for On-line Spatio-temporal Disease Surveillance. Environmetrics, 16(5), 423-434.
    \item Wood ATA, Chan G (1994). Simulation of Stationary Gaussian Processes in [0,1]d. Journal of Computational and Graphical Statistics, 3(4), 409-432.
    \item Moller J, Syversveen AR, Waagepetersen RP (1998). Log Gaussian Cox Processes. Scandinavian Journal of Statistics, 25(3), 451-482.
}
}
\seealso{
\link{minimum.contrast}, \link{minimum.contrast.spatiotemporal}, link{chooseCellWidth}, \link{getpolyol}, \link{guessinterp}, \link{getZmat},
\link{addTemporalCovariates}, \link{lgcpPrior}, \link{lgcpInits}, \link{CovFunction}
\link{lgcpPredictSpatialPlusPars},  \link{lgcpPredictSpatioTemporalPlusPars}, 
\link{lgcpPredictMultitypeSpatialPlusPars},
\link{ltar}, \link{autocorr}, \link{parautocorr}, \link{traceplots}, \link{parsummary}, \link{textsummary},
\link{priorpost}, \link{postcov}, \link{exceedProbs}, \link{betavals}, \link{etavals}
}

