\name{plot.lgcpAutocorr}
\alias{plot.lgcpAutocorr}
\title{plot.lgcpAutocorr function}
\usage{
  \method{plot}{lgcpAutocorr} (x, sel = 1:dim(x)[3],
    ask = TRUE, crop = TRUE, plotwin = FALSE, ...)
}
\arguments{
  \item{x}{an object of class lgcpAutocorr}

  \item{sel}{vector of integers between 1 and grid$len:
  which grids to plot. Default NULL, in which case all
  grids are plotted.}

  \item{ask}{logical; if TRUE the user is asked before each
  plot}

  \item{crop}{whether or not to crop to bounding box of
  observation window}

  \item{plotwin}{logical whether to plot the window
  attr(x,"window"), default is FALSE}

  \item{...}{other arguments passed to image.plot}
}
\value{
  a plot
}
\description{
  Plots \code{lgcpAutocorr} objects: output from
  \code{autocorr}
}
\examples{
\dontrun{ac <- autocorr(lg,qt=c(1,2,3))}
                          # assumes that lg has class lgcpPredict
\dontrun{plot(ac)}
}
\seealso{
  \link{autocorr}
}

