#' Combined Jockers & Rinker Polarity Lookup Table
#'
#' A \pkg{data.table} dataset containing a combined and augmented version of
#' Jockers (2017) & Rinker's augmented Hu & Liu (2004) positive/negative word
#' list as sentiment lookup values.
#'
#' @details
#' \itemize{
#'   \item x. Words
#'   \item y. Sentiment
#' }
#'
#' @docType data
#' @keywords datasets
#' @name hash_sentiment_jockers_rinker
#' @usage data(hash_sentiment_jockers_rinker)
#' @format A data frame with 11,709 rows and 2 variables
#' @references Jockers, M. L. (2017). Syuzhet: Extract sentiment and plot arcs
#' from Text. Retrieved from https://github.com/mjockers/syuzhet \cr \cr
#'
#' Hu, M., & Liu, B. (2004). Mining and summarizing customer reviews.
#' Proceedings of the ACM SIGKDD International Conference on Knowledge Discovery
#' & Data Mining (KDD-2004). Seattle, Washington.
NULL


