## ---------------------------------------------------------------------------------------------------------------------
library("lessR")
library("knitr")

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("Employee")

## ---------------------------------------------------------------------------------------------------------------------
pivot(data=d, compute=mean, value=Salary, rows_by=c(Dept, Gender))

## ---------------------------------------------------------------------------------------------------------------------
a <- pivot(d, mean, Salary, c(Dept, Gender))

## ---------------------------------------------------------------------------------------------------------------------
Sort(a, by=Dept)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, mean, c(Years, Salary), c(Dept, Gender), digits_d=2)

## ---------------------------------------------------------------------------------------------------------------------
# d %>% pivot(mean, Salary, c(Dept, Gender)) %>% -> a

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, mean, Salary, Dept, Gender)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, mean, Salary, Dept, c(Gender, Plan))

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, tabulate, c(Dept, Gender))

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, mean, Years, Dept)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, mean, Years, Dept, na_remove=FALSE)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, mean, Years, Dept, na_remove=FALSE, na_value=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, mean, Years, c(Dept, Gender), na_by=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, tabulate, c(Dept, Gender), na_by=TRUE)

