% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_history.R
\name{get_history}
\alias{get_history}
\title{Fetch Wikipedia 'History' table}
\format{Data frame with columns:
\itemize{
\item{pageid: Wikipedia page ID identifying a legislator's Wikipedia biography (of class \sQuote{integer}).}
\item{revid: Wikipedia edit ID (of class \sQuote{integer}).}
\item{parentid: Wikipedia edit ID of the previous revision (of class \sQuote{integer}).}
\item{user: Username of registered user responsible for the revision, IP address in case of anonymous revision (of class \sQuote{character}).}
\item{userid: ID of registered user responsible for the revision, 0 in case of anonymous revision (of class \sQuote{integer}).}
\item{timestamp: Date and time of the revision (of class \sQuote{POSIXct}).}
\item{size: Revision size in bytes (of class \sQuote{integer}).}
\item{comment: Revision comment (of class \sQuote{character}).}
}}
\source{
Wikipedia API, \url{https://wikipedia.org/w/api.php}
}
\usage{
get_history(legislature)
}
\arguments{
\item{legislature}{A character string specifying the three-letter country code of the legislature for which data shall be fetched. Currently one of \sQuote{aut}, \sQuote{can}, \sQuote{cze}, \sQuote{esp}, \sQuote{fra}, \sQuote{deu}, \sQuote{irl}, \sQuote{sco}, \sQuote{gbr}, \sQuote{usa_house}, or \sQuote{usa_senate}.}
}
\value{
A data frame with columns as specified above.
}
\description{
Fetches full revision histories of legislators' Wikipedia biographies for the specified legislature. Requires a working Internet connection.
}
\examples{
\donttest{# Get entire 'History' table for the Austrian Nationalrat
aut_history <- get_history(legislature = "aut")
tibble::glimpse(aut_history)

# Get 'History' table for NEOS party members of the Austrian Nationalrat
aut_history_subset <- dplyr::semi_join(x = aut_history,
                                       y = dplyr::filter(get_political(legislature = "aut"),
                                                         party == "NEOS"),
                                       by = "pageid")
tibble::glimpse(aut_history_subset)
}
}
