% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popchar.R
\name{density_vr}
\alias{density_vr}
\title{Set Density Dependence Relationships in Vital Rates}
\usage{
density_vr(
  density_yn = c(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
    FALSE, FALSE, FALSE, FALSE),
  style = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
  time_delay = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
  alpha = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
  beta = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
)
}
\arguments{
\item{density_yn}{A 14 element logical vector denoting whether each vital
rate is subject to density dependence. The order of vital rates is: survival
probability, observation probability, primary size transition, secondary size
transition, tertiary size transition, reproductive status probability,
fecundity rate, juvenile survival probability, juvenile observation
probability, juvenile primary size transition, juvenile secondary size
transition, juvenile tertiary size transition, juvenile reproductive status
probability, and juvenile maturity status probability. Defaults to a vector
of 14 \code{FALSE} values.}

\item{style}{A 14 element vector coding for the style of density dependence
on each vital rate. Options include \code{0}: no density dependence,
\code{1}, \code{ricker}, \code{ric}, or \code{r} for the Ricker function;
\code{2}, \code{beverton}, \code{bev}, and \code{b} for the Beverton-Holt
function; \code{3}, \code{usher}, \code{ush}, and \code{u} for the Usher
function; and \code{4}, \code{logistic}, \code{log}, and \code{l} for the
logistic function. Defaults to 14 values of \code{0}.}

\item{time_delay}{A 14 element vector indicating the number of occasions back
on which density dependence operates. Defaults to 14 values of \code{1}, and
may not include any number less than 1.}

\item{alpha}{A 14 element vector indicating the numeric values to use as the
alpha term in the two parameter Ricker, Beverton-Holt, or Usher function, or
the value of the carrying capacity \emph{K} to use in the logistic equation
(see \code{Notes} for more on this term). Defaults to 14 values of \code{0}.}

\item{beta}{A 14 element vector indicating the numeric values to use as the
beta term in the two parameter Ricker, Beverton-Holt, or Usher function. Used
to indicate whether to use \emph{K} as a hard limit in the logistic equation
(see \code{Notes} below). Defaults to 14 values of \code{0}.}
}
\value{
A data frame of class \code{lefkoDensVR} with 14 rows, one for each
vital rate in the order of: survival probability, observation probability,
primary size transition, secondary size transition, tertiary size transition,
reproductive status probability, fecundity rate, juvenile survival
probability, juvenile observation probability, juvenile primary size
transition, juvenile secondary size transition, juvenile tertiary size
transition, juvenile reproductive status probability, and juvenile maturity
status probability. This object can be used as input in function
\code{\link{f_projection3}()}.

Variables in this object include the following:
\item{vital_rate}{The vital rate to be modified.}
\item{density_yn}{Logical value indicating whether vital rate will be subject
to density dependence.}
\item{style}{Style of density dependence, coded as \code{1}, \code{2},
\code{3}, \code{4}, or \code{0} for the Ricker, Beverton-Holt, Usher, or
logistic function, or no density dependence, respectively.}
\item{time_delay}{The time delay on density dependence, in time steps.}
\item{alpha}{The value of alpha in the Ricker, Beverton-Holt, or Usher
function, or the value of carrying capacity, \emph{K}, in the logistic
function.}
\item{beta}{The value of beta in the Ricker, Beverton-Holt, or Usher
function.}
}
\description{
Function \code{density_vr()} provides all necessary data to incorporate
density dependence into the vital rate functions used to create matrices in
function-based projections using function \code{f_projection3()}. Four forms
of density dependence are allowed, including the Ricker function, the
Beverton-Holt function, the Usher function, and the logistic function. In
each case, density must have an effect with at least a one time-step delay
(see Notes).
}
\section{Notes}{

This function provides inputs when density dependence is operationalized
directly on vital rates. It can be used only in function
\code{f_projection3()}. Users wishing to modify matrix elements directly by
density dependence functions for use in function-based or raw projections
with functions \code{projection3()} and \code{f_projection3()} should use
function \code{density_input()} to provide the correct inputs.

The parameters \code{alpha} and \code{beta} are applied according to the
two-parameter Ricker function, the two-parameter Beverton-Holt function, the
two-parameter Usher function, or the one-parameter logistic function.
Although the default is that a 1 time step delay is assumed, greater time
delays can be set through the \code{time_delay} option.

When using the logistic function, it is possible that the time delay used in
density dependent simulations will cause matrix elements to become negative.
To prevent this behavior, set the associated \code{beta} term to \code{1.0}.
Doing so will set \code{K} as the hard limit in the logistic equation,
essentially setting a minimum limit at \code{0} for all matrix elements
modified.
}

\examples{
\donttest{
data(lathyrus)

sizevector <- c(0, 4.6, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8,
  9)
stagevector <- c("Sd", "Sdl", "Dorm", "Sz1nr", "Sz2nr", "Sz3nr", "Sz4nr",
  "Sz5nr", "Sz6nr", "Sz7nr", "Sz8nr", "Sz9nr", "Sz1r", "Sz2r", "Sz3r", 
  "Sz4r", "Sz5r", "Sz6r", "Sz7r", "Sz8r", "Sz9r")
repvector <- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1)
obsvector <- c(0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0)
indataset <- c(0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 4.6, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 
  0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5)

lathframeln <- sf_create(sizes = sizevector, stagenames = stagevector, 
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector, 
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec, 
  propstatus = propvector)

lathvertln <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9, 
  juvcol = "Seedling1988", sizeacol = "lnVol88", repstracol = "Intactseed88",
  fecacol = "Intactseed88", deadacol = "Dead1988", 
  nonobsacol = "Dormant1988", stageassign = lathframeln, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, NAas0 = TRUE, censor = TRUE)

lathvertln$feca2 <- round(lathvertln$feca2)
lathvertln$feca1 <- round(lathvertln$feca1)
lathvertln$feca3 <- round(lathvertln$feca3)

lathmodelsln3 <- modelsearch(lathvertln, historical = TRUE, 
  approach = "mixed", suite = "main", 
  vitalrates = c("surv", "obs", "size", "repst", "fec"), juvestimate = "Sdl",
  bestfit = "AICc&k", sizedist = "gaussian", fecdist = "poisson", 
  indiv = "individ", patch = "patchid", year = "year2", year.as.random = TRUE,
  patch.as.random = TRUE, show.model.tables = TRUE, quiet = "partial")

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "mat", "Sd", "Sdl"), 
  stage2 = c("Sd", "Sd", "Sd", "Sd", "Sdl", "rep", "rep"),
  stage1 = c("Sd", "rep", "Sd", "rep", "Sd", "mat", "mat"),
  eststage3 = c(NA, NA, NA, NA, "mat", NA, NA),
  eststage2 = c(NA, NA, NA, NA, "Sdl", NA, NA),
  eststage1 = c(NA, NA, NA, NA, "Sdl", NA, NA),
  givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, 0.345, 0.054),
  type = c(1, 1, 1, 1, 1, 3, 3), type_t12 = c(1, 2, 1, 2, 1, 1, 1),
  stageframe = lathframeln, historical = TRUE)

# While we do not use MPMs to initialize f_projections3(), we do use MPMs to
# initialize functions start_input() and density_input().
lathmat3ln <- flefko3(year = "all", patch = "all", stageframe = lathframeln, 
  modelsuite = lathmodelsln3, data = lathvertln, supplement = lathsupp3, 
  reduce = FALSE)

e3m_sv <- start_input(lathmat3ln, stage2 = "Sd", stage1 = "Sd", value = 1000)

dyn7 <- c(TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
  FALSE, FALSE, FALSE, FALSE, FALSE)
dst7 <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
dal7 <- c(0.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
dbe7 <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

e3d_vr <- density_vr(density_yn = dyn7, style = dst7, alpha = dal7,
  beta = dbe7)

trial7_dvr <- f_projection3(format = 1, data = lathvertln,
  modelsuite = lathmodelsln3, stageframe = lathframeln, nreps = 2,
  times = 100, stochastic = TRUE, standardize = FALSE, growthonly = TRUE,
  integeronly = FALSE, substoch = 0, sp_density = 0, start_frame = e3m_sv,
  density_vr = e3d_vr)
summary(trial7_dvr)
}

}
\seealso{
\code{\link{density_input}()}

\code{\link{f_projection3}()}
}
