% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{stablestage3.lefkoMat}
\alias{stablestage3.lefkoMat}
\title{Estimate Stable Stage Distribution of Matrices in lefkoMat Object}
\usage{
\method{stablestage3}{lefkoMat}(
  mats,
  stochastic = FALSE,
  times = 10000,
  tweights = NA,
  seed = NA,
  sparse = "auto",
  ...
)
}
\arguments{
\item{mats}{An object of class \code{lefkoMat}.}

\item{stochastic}{A logical value indicating whether to use deterministic
(\code{FALSE}) or stochastic (\code{TRUE}) analysis. Defaults to
\code{FALSE}.}

\item{times}{An integer variable indicating number of occasions to project if
using stochastic analysis. Defaults to 10000.}

\item{tweights}{An optional vector indicating the probability weighting to
use for each matrix in stochastic simulations. If not given, then defaults to
equal weighting.}

\item{seed}{A number to use as a random number seed.}

\item{sparse}{A text string indicating whether to use sparse matrix encoding
(\code{"yes"}) or dense matrix encoding (\code{"no"}). Defaults to
\code{"auto"}.}

\item{...}{Other parameters.}
}
\value{
This function returns the stable stage distributions (and long-run
mean stage distributions in stochastic analysis) corresponding to the
matrices in a \code{lefkoMat} object.

The output depends on whether the \code{lefkoMat} object used as input is
ahistorical or historical, and whether the analysis is deterministic or
stochastic. If deterministic and ahistorical, then a single data frame is
output, which includes the number of the matrix within the \code{A} element
of the input \code{lefkoMat} object, followed by the stage id (numeric and
assigned through \code{\link{sf_create}()}), the stage name, and the
estimated proportion of the stable stage distribution (\code{ss_prop}). If
stochastic and ahistorical, then a single data frame is output starting with
the number of the population-patch (\code{matrix_set}), a string
concatenating the names of the population and the patch (\code{poppatch}),
the assigned stage id number (\code{stage_id}), and the stage name
(\code{stage}), and the long-run average stage distribution (\code{ss_prop}).

If a historical matrix is used as input, then two data frames are output
into a list object. The \code{hist} element describes the historical
stage-pair distribution, while the \code{ahist} element describes the stage
distribution. If deterministic, then \code{hist} contains a data frame
including the matrix number (\code{matrix}), the numeric stage designations for
stages in occasions \emph{t} and \emph{t}-1, (\code{stage_id_2} and
\code{stage_id_1}, respectively), followed by the respective stage names (
\code{stage_2} and \code{stage_1}), and ending with the estimated stable
stage-pair distribution. The associated \code{ahist} element is as before. If
stochastic, then the \code{hist} element contains a single data frame with
the number of the population-patch (\code{matrix_set}), a string
concatenating the names of the population and the patch (\code{poppatch}),
the assigned stage id numbers in times \emph{t} and \emph{t}-1 (
\code{stage_id_2} and \code{stage_id_2}, respectively), and the associated
stage names (\code{stage_2} and \code{stage_1}, respectively), and the
long-run average stage distribution (\code{ss_prop}). The associated
\code{ahist} element is as before in the ahistorical, stochastic case.

In addition to the data frames noted above, stochastic analysis will result
in the additional output of a list of matrices containing the actual
projected stage distributions across all projected occasions, in the order of
population-patch combinations in the \code{lefkoMat} input.
}
\description{
\code{stablestage3.lefkoMat()} returns the deterministic stable stage
distributions of all \code{A} matrices in an object of class \code{lefkoMat},
as well as the long-run projected mean stage distribution in stochastic
analysis. This function can handle large and sparse matrices, and so can be
used with large historical matrices, IPMs, age x stage matrices, as well as
ahistorical matrices.
}
\section{Notes}{

In stochastic analysis, the projected mean distribution is the arithmetic
mean across the final 1000 projected occasions if the simulation is at least
2000 projected occasions long. If between 500 and 2000 projected occasions
long, then only the final 200 are used, and if fewer than 500 occasions are
used, then all are used. Note that because stage distributions in stochastic
simulations can change greatly in the initial portion of the run, we
encourage a minimum of 2000 projected occasions per simulation, with 10000
preferred.
}

\examples{
# Lathyrus deterministic example
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl", "mat"),
  stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep", "Sdl"),
  stage1 = c("Sd", "rep", "Sd", "rep", "npr", "npr", "Sd"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, "mat"),
  eststage2 = c(NA, NA, NA, NA, NA, NA, "Sdl"),
  eststage1 = c(NA, NA, NA, NA, NA, NA, "NotAlive"),
  givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, 0.345, 0.054, NA),
  type = c(1, 1, 1, 1, 3, 3, 1), type_t12 = c(1, 2, 1, 2, 1, 1, 1),
  stageframe = lathframe, historical = TRUE)

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = "all", 
  stages = c("stage3", "stage2", "stage1"), supplement = lathsupp3,
  yearcol = "year2", indivcol = "individ")

ehrlen3mean <- lmean(ehrlen3)
stablestage3(ehrlen3mean)

# Cypripedium stochastic example
rm(list=ls(all=TRUE))
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

# Here we use supplemental() to provide overwrite and reproductive info
cypsupp2r <- supplemental(stage3 = c("SD", "P1", "P2", "P3", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "rep",
    "rep"),
  eststage3 = c(NA, NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.10, 0.20, 0.20, 0.20, 0.25, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, 0.5, 0.5),
  type =c(1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
  stageframe = cypframe_raw, historical = FALSE)

cypmatrix2r <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")

stablestage3(cypmatrix2r, stochastic = TRUE)

}
\seealso{
\code{\link{stablestage3}()}

\code{\link{stablestage3.matrix}()}
}
