% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{lmean}
\alias{lmean}
\title{Estimate Mean Projection Matrices}
\usage{
lmean(mats, time = "arithmetic", sparse = FALSE, AasSum = TRUE)
}
\arguments{
\item{mats}{A \code{lefkoMat} object holding population projection matrices.}

\item{time}{A variable designating whether element means be computed as 
geometric (\code{geometric} or \code{g}) or arithmetic (\code{arithmetic} or \code{a}) across 
time. Defaults to \code{arithmetic}.}

\item{sparse}{If TRUE, then all 0s will be ignored in elements that include
other numbers across matrices. Only elements that equal 0 in all matrices
(structural zeroes) will be exempt. Defaults to FALSE.}

\item{AasSum}{If TRUE, then lefkoMat matrix means are estimated as means of
U and F matrices, and then summed to estimate A matrices. If FALSE, then
mean A matrices are estimated as means of A matrices within lefkoMat objects.
Defaults to TRUE.}
}
\value{
Yields a \code{lefkoMat} object with the following characteristics:

\item{A}{A list of full mean projection matrices in order of sorted
populations,patches, and years. These are typically estimated as the sums
of associated mean \code{U} and \code{F} matrices.}
\item{U}{A list of mean survival-transition matrices sorted as in \code{A}.}
\item{F}{A list of mean fecundity matrices sorted as in \code{A}.}
\item{hstages}{A data frame matrix showing the pairing of ahistorical 
stages used to create historical stage pairs.}
\item{ahstages}{A data frame detailing the characteristics of associated
ahistorical stages.}
\item{labels}{A data frame giving the population, patch, and year of each 
mean matrix in order. If \code{pop}, \code{patch}, or \code{year2} are all NA in the
original \code{labels} set, then these will be re-labeled as \code{A}, \code{1}, or \code{1},
respectively.}
\item{matrixqc}{A short vector describing the number of non-zero elements
in \code{U} and \code{F} mean matrices, and the number of annual matrices.}
\item{modelqc}{The \code{qc} portion of the modelsuite input, if used.}
\item{dataqc}{A vector showing the numbers of individuals and rows in the
vertical dataset used as input.}
}
\description{
\code{lmean()} estimates mean projection matrices. The function differs from a
typical element-by-element mean matrix estimator through two options. First,
it allows mean matrix element to be estimated as geometric means across time. 
Spatial means are always developed as arithmetic means. Second, it allows 
element means to be estimated ignoring 0s in cases where some elements are 
not zero. The function takes \code{lefkoMat} objects as input, and returns the 
same class of object.
}
\examples{
\donttest{
data(lathyrus)
sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector, repstatus = repvector, 
                       obsstatus = obsvector, matstatus = matvector, immstatus = immvector, 
                       indataset = indataset, binhalfwidth = binvec, propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988, patchidcol = "SUBPLOT", 
                         individcol = "GENET", blocksize = 9, juvcol = "Seedling1988", 
                         size1col = "Volume88", repstr1col = "FCODE88", 
                         fec1col = "Intactseed88", dead1col = "Dead1988", 
                         nonobs1col = "Dormant1988", stageassign = lathframe, 
                         stagesize = "sizea", censorcol = "Missing1988", 
                         censorkeep = NA, censor = TRUE)

lathrepm <- matrix(0, 7, 7)
lathrepm[1, 6] <- 0.345
lathrepm[2, 6] <- 0.054

lathover3 <- overwrite(stage3 = c("Sd", "Sd", "Sdl"), stage2 = c("Sd", "Sd", "Sd"), 
                       stage1 = c("Sd", "rep", "rep"), givenrate = c(0.345, 0.054))

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = c(1989, 1990), 
                   stages = c("stage3", "stage2", "stage1"), repmatrix = lathrepm, 
                   overwrite = lathover3, yearcol = "year2", 
                   indivcol = "individ")

ehrlen3mean <- lmean(ehrlen3)
ehrlen3mean$A[[1]]
}

}
