% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{run_tutorial}
\alias{run_tutorial}
\title{Run a tutorial}
\usage{
run_tutorial(name = NULL, package = NULL, shiny_args = NULL)
}
\arguments{
\item{name}{Tutorial name (subdirectory within \code{tutorials/}
directory of installed package).}

\item{package}{Name of package}

\item{shiny_args}{Additional arguments to forward to
\code{\link[shiny:runApp]{shiny::runApp}}.}
}
\description{
Run a tutorial which is contained within an R package.
}
\details{
Note that when running a tutorial Rmd file with \code{run_tutorial}
the tutorial Rmd should have already been rendered as part of the
development of the package (i.e. the corresponding tutorial .html file for
the .Rmd file must exist).
}
\examples{
# display all "learnr" tutorials
available_tutorials("learnr")

# run basic example within learnr
\dontrun{run_tutorial("hello", "learnr")}
}
\seealso{
\code{\link{safe}} and \code{\link{available_tutorials}}
}
