% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geojsonMap.R
\name{geojsonMap}
\alias{geojsonMap}
\title{Load amap to leaflet}
\usage{
geojsonMap(dat, mapName, namevar=NULL, valuevar=NULL,
  palette = "Blues", colorMethod = "numeric",
  na.color = "#808080", popup = NULL, stroke = T, smoothFactor = 1,
   weight = 1, fillOpacity = 0.7, legendTitle = "Legend", ...)
}
\arguments{
\item{dat}{a data.frame contain regions and values}

\item{mapName}{mapName for loading, eg. 'china', 'city', ...}

\item{namevar}{show which feature is chosen for name variable}

\item{valuevar}{show which featue is chosen for value variable}

\item{palette}{The colors or color function that values will be mapped to, see RColorBrewer::display.brewer.all()}

\item{colorMethod}{set one of the coloe mapping in c("numeric", "bin", "quantile", "Factor")}

\item{na.color}{The color to return for NA values. Note that na.color=NA is valid.}

\item{popup}{a character vector of the HTML content for the popups (you are recommended to escape the text using htmlEscape() for security reasons)}

\item{stroke}{whether to draw stroke along the path (e.g. the borders of polygons or circles)}

\item{smoothFactor}{how much to simplify the polyline on each zoom level (more means better performance and less accurate representation)}

\item{weight}{stroke width in pixels}

\item{fillOpacity}{fill opacity}

\item{legendTitle}{legend title}

\item{...}{other paramter pass to the color mapping function}
}
\description{
Simple function like addTiles()
}
\examples{
dat = data.frame(name = regionNames("city"),
                 value = runif(384))
geojsonMap(dat,"city")

dat$value2 = cut(dat$value, c(0, 0.25, 0.5, 1))
geojsonMap(dat,"city",
  namevar = ~name,
  valuevar = ~value2,
  palette="Reds",
  colorMethod="factor")

geojsonMap(dat,"city",
  namevar = ~name,
  valuevar = ~value2,
  palette = topo.colors(3),
  colorMethod="factor")
}

