% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicMapLayers.R
\name{addEsriDynamicMapLayer}
\alias{addEsriDynamicMapLayer}
\title{Render and visualize Map Services from ArcGIS Online and ArcGIS Server.}
\usage{
addEsriDynamicMapLayer(map, url, options = dynamicMapLayerOptions(),
  popupFunction = NULL, popupOptions = NULL, layerId = NULL,
  group = NULL)
}
\arguments{
\item{map}{The leaflet map}

\item{url}{URL of the \href{http://resources.arcgis.com/en/help/arcgis-rest-api/#/Map_Service/02r3000000w2000000/}{Map Service}.}

\item{options}{options for the dynamic map layer.}

\item{popupFunction}{Uses the provided function to create a popup that will
identify features whenever the map is clicked.
Your function will be passed a GeoJSON FeatureCollection of the features
 at the clicked location and should return the appropriate HTML.
 If you do not want to open the popup when there are no results, return false.}

\item{popupOptions}{See \code{\link[leaflet]{popupOptions}}.}

\item{layerId}{A unique ID for the layer.}

\item{group}{The name of the group this layer should be added to.}
}
\description{
Map Services are a way to expose the contents of a map as a web service and
expose capabilities for exporting tile images, querying and
identifying features and more.
Also supports custom popups and identification of features.
}
