% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addRasterRGB.R
\name{addRasterRGB}
\alias{addRasterRGB}
\alias{addStarsRGB}
\title{Add an RGB image as a layer}
\usage{
addRasterRGB(
  map,
  x,
  r = 3,
  g = 2,
  b = 1,
  quantiles = c(0, 1),
  domain = NULL,
  na.color = "#BEBEBE80",
  ...
)

addStarsRGB(
  map,
  x,
  r = 3,
  g = 2,
  b = 1,
  quantiles = c(0, 1),
  domain = NULL,
  na.color = "#BEBEBE80",
  ...
)
}
\arguments{
\item{map}{a map widget object created from `leaflet()``}

\item{x}{a  `RasterBrick`, `RasterStack` or `stars`` raster object}

\item{r}{integer. Index of the Red channel/band, between 1 and nlayers(x)}

\item{g}{integer. Index of the Green channel/band, between 1 and nlayers(x)}

\item{b}{integer. Index of the Blue channel/band, between 1 and nlayers(x)}

\item{quantiles}{the upper and lower quantiles used for color stretching.
If set to NULL, stretching is performed basing on `domain` argument.}

\item{domain}{the upper and lower values used for color stretching.
This is used only if `quantiles` is NULL.
If both `domain` and `quantiles` are set to NULL, stretching is applied
based on min-max values.}

\item{na.color}{the color to be used for NA pixels}

\item{...}{additional arguments passed on to \code{\link{addRasterImage}}}
}
\description{
Create a Red-Green-Blue image overlay from a \code{RasterStack} /
\code{RasterBrick} or \code{stars} object based on three layers.
Three layers (sometimes referred to as "bands" because they may represent
different bandwidths in the electromagnetic spectrum) are combined such
that they represent the red, green and blue channel. This function can
be used to make 'true (or false) color images' from Landsat and other
multi-band satellite images. Note, this text is plagirized, i.e. copied
from \code{\link{plotRGB}}.
\code{AddRasterRGB} and \code{addStarsRGB} are aliases.
}
\examples{
\donttest{
  require(raster)
  require(stars)
  require(plainview)
  require(leaflet)

  leaflet() \%>\%
    addTiles(group = "OpenStreetMap") \%>\%
    addRasterRGB(plainview::poppendorf, 4,3,2, group = "True colours") \%>\%
    addStarsRGB(st_as_stars(plainview::poppendorf), 5,4,3, group = "False colours") \%>\%
    addLayersControl(
      baseGroups = c("Satellite"),
      overlayGroups = c("True colours", "False colours"),
    )
}

}
\author{
Tim Appelhans, Luigi Ranghetti
}
