% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{to.data.frame}
\alias{to.data.frame}
\title{Converts an \code{ldtv} object to a \code{data.frame}}
\usage{
to.data.frame(
  x,
  types = c("bestweights", "allweights", "inclusion", "type1bests", "cdf",
    "extremebounds", "mixture"),
  measures = NULL,
  targets = NULL,
  rows = NULL,
  columns = NULL,
  itemIndices = NULL,
  colNamFun = function(ns) {
     paste(ns[lengths(ns) > 0], collapse = ".")
 },
  rowContent = c("measure", "target", "item", "row", "column"),
  cdfIndex = 0,
  ...
)

to.data.frame(
  x,
  types = c("bestweights", "allweights", "inclusion", "type1bests", "cdf",
    "extremebounds", "mixture"),
  measures = NULL,
  targets = NULL,
  rows = NULL,
  columns = NULL,
  itemIndices = NULL,
  colNamFun = function(ns) {
     paste(ns[lengths(ns) > 0], collapse = ".")
 },
  rowContent = c("measure", "target", "item", "row", "column"),
  cdfIndex = 0,
  ...
)
}
\arguments{
\item{x}{an \code{ldtsearch} object}

\item{types}{(string vector) one or more that one type of information
to be included in the the data.frame}

\item{measures}{(integer or character array) measures to be used.}

\item{targets}{(integer or character array) targets to be used.}

\item{rows}{(integer or character array) If the requested object is a matrix
(or an array), it determines the rows and cannot be \code{NULL}. For
\code{type1bests} this is the name of the variables.}

\item{columns}{(integer or character array) If the requested object is
a matrix, it determines the columns and cannot be \code{NULL}. For
\code{type1bests} this is the name of the fields: \code{weight}, \code{mean}, \code{var}}

\item{itemIndices}{(integer array) items such as \code{bests} to be used.}

\item{colNamFun}{(function) a function to determine the column names. The
argument is a list of names, i.e., one of the following items: \code{target},
\code{measure}, \code{row}, \code{column}, \code{item}.}

\item{rowContent}{(string) determines the type of information in the rows of
returned \code{data.frame}. Some items are not available for some \code{types}.
\code{row} is generally for variables in the rows of matrices such as \code{inclusion} or
\code{mixture}. \code{column} is generally for the columns of such matrices.
\code{item} is for the \code{best} models or models in the \code{all} field.}

\item{cdfIndex}{(integer) The index of CDF if \code{type} is \code{cdf}}

\item{...}{additional arguments}
}
\value{
a data.frame that contains data.
}
\description{
There are five types of indices in this function: measures,
targets, bests, type1's items, equations.
Use \code{NULL} to use all available information or specify them.
}
