% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetRoc}
\alias{GetRoc}
\title{ROC curve for a binary case}
\usage{
GetRoc(y, scores, weights = NULL, options = NULL, printMsg = FALSE)
}
\arguments{
\item{y}{(numeric vector, \code{Nx1}) Actual values}

\item{scores}{(numeric vector, \code{Nx1}) Calculated probabilities for the negative observations}

\item{weights}{(numeric vector, \code{Nx1}) Weights of the observations. Use \code{NULL} for equal weights.}

\item{options}{(list) More options. See \code{\link[=GetRocOptions]{GetRocOptions()}} function for details.}

\item{printMsg}{(bool) Set true to report some details.}
}
\value{
A list with the following items:
\item{N}{(integer) Number of observations}
\item{AUC}{(numeric) Value of AUC}
\item{Points}{(numeric matrix) Points for ploting ROC}
}
\description{
It does not draw the ROC, but calculatates the required points. It also
Calculates the AUC with different options
}
\examples{
y <- c(1, 0, 1, 0, 1, 1, 0, 0, 1, 0)
scores <- c(0.1, 0.2, 0.3, 0.5, 0.5, 0.5, 0.7, 0.8, 0.9, 1)
res1 = GetRoc(y,scores, printMsg = FALSE)
costs <- c(1,2,1,4,1,5,1,1,0.5,1)
costMatrix = matrix(c(0.02,-1,-3,3),2,2)
opt <- GetRocOptions(costs = costs, costMatrix = costMatrix)
res2 = GetRoc(y,scores,NULL,options = opt, printMsg = FALSE)
#plot(res1$Points)
#lines(res2$Points)

}
