% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{Data_WdiSearchFor}
\alias{Data_WdiSearchFor}
\title{Search For Series in WDI Data}
\usage{
Data_WdiSearchFor(
  series,
  keywords,
  searchName = TRUE,
  searchDesc = FALSE,
  topickeywords = NULL,
  findOne = FALSE,
  ...
)
}
\arguments{
\item{series}{The series member of an output from \code{\link{Data_Wdi}} function.}

\item{keywords}{(character array) strings to search for.}

\item{searchName}{if \code{FALSE}, it does not search in the name}

\item{searchDesc}{if \code{FALSE}, it does not search in the description}

\item{topickeywords}{If given, topic of a matched case must contain this string, too.}

\item{findOne}{Raises error if \code{TRUE} and more than 1 series
is found. default is \code{FALSE}.}

\item{...}{additional arguments}
}
\value{
a list with series information or if \code{findOne} is \code{TRUE} a series information.
}
\description{
it searches in code, (name and description) of the series.
}
\examples{
\donttest{
#data <- Data_Wdi() # this is time-consuming and requires WDI dataset files
#res <- Data_WdiSearchFor(data$series, c("GDP per capita"),
#                        TRUE, topickeywords = "national account")
}

}
