% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{Data_VestaFraud}
\alias{Data_VestaFraud}
\title{Use 'Vesta' Data (i.e., 'IEEE-CIS Fraud Detection') and create \code{Fraud-Series} Table}
\usage{
Data_VestaFraud(
  dirPath,
  training = TRUE,
  t_dumCols = NULL,
  i_dumCols = NULL,
  cat_min_unique_skip = 6
)
}
\arguments{
\item{dirPath}{path to the downloaded data directory.}

\item{training}{If \code{FALSE}, it loads test data}

\item{t_dumCols}{a \code{list} with \code{name} and \code{values} of (categorical) columns
in 'transaction' file to be converted to dummy variables. If \code{training} is \code{FALSE}
and this is \code{NULL}, a warning is raised.}

\item{i_dumCols}{similar to \code{t_dumCols} but for 'identity' file.}

\item{cat_min_unique_skip}{If \code{t_dumCols} or \code{i_dumCols} is \code{NULL},
for a categorical variable, if number of unique values is equal or larger than this value, it is omitted.}
}
\value{
a list:
\itemize{
\item \code{data}: a data.frame with the data
\item \code{t_dumCols}: a \code{list} with \code{name} and \code{values} in
'transaction' data, used for creating the dummy variable
\item \code{i_dumCols}: a \code{list} with \code{name} and \code{values} in
'identity' data, used for creating the dummy variable
}
}
\description{
Use 'Vesta' Data (i.e., 'IEEE-CIS Fraud Detection') and create \code{Fraud-Series} Table
}
