% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCR.R
\name{cvPCR}
\alias{cvPCR}
\title{Cross validation of PCR reconstruction.}
\usage{
cvPCR(
  Qa,
  pc,
  start.year,
  transform = "log",
  Z = NULL,
  metric.space = "transformed"
)
}
\arguments{
\item{Qa}{Observations: a data.frame of annual streamflow with at least two columns: year and Qa.}

\item{pc}{For a single model: a data.frame, one column for each principal component. For an ensemble reconstruction: a list, each element is a data.frame of principal components.}

\item{start.year}{Starting year of the climate proxies, i.e, the first year of the paleo period. \code{start.year + nrow(pc) - 1} will determine the last year of the study horizon, which must be greater than or equal to the last year in \code{Qa}.}

\item{transform}{Flow transformation, either "log", "boxcox" or "none". Note that if the Box-Cox transform is used, the confidence interval after back-transformation is simply the back-transform of the trained onfidence interval; this is hackish and not entirely accurate.}

\item{Z}{A list of cross-validation folds. If \code{NULL}, will be created with \code{make_Z()} with default settings. Users are advised to use \code{make_Z()} to create the cross-validation folds beforehand. See \link{make_Z} for details.}

\item{metric.space}{Either "transformed" or "original", the space to calculate the performance metrics.}
}
\value{
A list of cross validation results
\itemize{
\item metrics.dist: distribution of performance metrics across all cross-validation runs; a matrix, one column for each metric, with column names.
\item metrics: average performance metrics; a named vector.
\item obs: the (transformed) observations, a data.table with two columns (year, y)
\item Ycv: the predicted streamflow in each cross validation run; a matrix, one column for each cross-validation run
\item Z: the cross-validation fold
}
}
\description{
Cross validation of PCR reconstruction.
}
\examples{
cvPCR(NPannual, NPpc, start.year = 1200)
}
