% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/search_heuristic.R
\name{search_heuristic}
\alias{search_heuristic}
\title{At each vertex of the search graph, this takes a step which moves the
proportions of conditions in the subspace closer to the desired
(or sample) proportions.}
\usage{
search_heuristic(sspace, condition, covariates, halting_test, thresh, props)
}
\arguments{
\item{sspace}{An ordered subject subspace: a list of vectors,
with one vector per group containing the corresponding subject indices.}

\item{condition}{A factor vector containing condition labels.}

\item{covariates}{A vector or columnwise matrix containing
                     covariates to match the conditions on.}

\item{halting_test}{A function to apply to `covariates` (in matrix form)
                     which is TRUE iff the conditions are matched.}

\item{thresh}{The statistical threshold to pass onto the
                     aforementioned test.}

\item{props}{The desired proportions (percentage) of the sample for
                     each condition; if not specified, the (full)
                     sample proportions are used. This is used
                     for the "heuristic" and "exhaustive" methods.}
}
\description{
At each vertex of the search graph, this takes a step which moves the
proportions of conditions in the subspace closer to the desired
(or sample) proportions.
}

