% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pruneSCLOP.R
\name{pruneSCLOP}
\alias{pruneSCLOP}
\alias{plot.PruningSCLOP}
\alias{pruning.par}
\title{Local Pruning State of Topic Dendrograms}
\usage{
pruneSCLOP(dend)

\method{plot}{PruningSCLOP}(x, dend, pruning.par, ...)

pruning.par(pruning)
}
\arguments{
\item{dend}{[\code{\link[stats]{dendrogram}}]\cr
\code{\link[=dendTopics]{TopicDendrogram}}
(and \code{\link[stats]{dendrogram}}) object of all considered topics as the
output from \code{\link{dendTopics}}.}

\item{x}{an R object.}

\item{pruning.par}{[\code{list}]\cr
List of parameters to mark the pruning. See section "Details" at \code{\link{dendTopics}}
for default parameters. Types for marking the pruning state are \code{"abline"},
\code{"color"} and \code{"both"}.}

\item{...}{additional arguments.}

\item{pruning}{[\code{list of \link[stats]{dendrogram}s}]\cr
\code{\link[=pruneSCLOP]{PruningSCLOP}} object specifying the best possible
local pruning state.}
}
\value{
[\code{list of \link[stats]{dendrogram}s}]
\code{\link[=pruneSCLOP]{PruningSCLOP}} object specifying the best possible
local pruning state.
}
\description{
The function \code{\link{SCLOP}} calculates the S-CLOP value for the best possible
local pruning state of a dendrogram from \code{\link{dendTopics}}.
The function \code{pruneSCLOP} supplies the corresponding pruning state itself.
}
\details{
For details of computing the S-CLOP values see \code{\link{SCLOP}}.

For details and examples of plotting the pruning state see \code{\link{dendTopics}}.
}
\seealso{
Other plot functions: 
\code{\link{dendTopics}()}

Other SCLOP functions: 
\code{\link{SCLOP}()}
}
\concept{SCLOP functions}
\concept{plot functions}
