% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m_top.R
\name{m_top}
\alias{m_top}
\title{m top technical analysis function}
\usage{
m_top(h,top,down,month,day)
}
\arguments{
\item{h}{an stock data}

\item{top}{an rsi rise horizon value}

\item{down}{an rsi down horizon value}

\item{month}{set the length between the start and end points. Unit:month}

\item{day}{check the correctness of the end point, set the length between the end and check points. Unit:day}
}
\value{
an analysis of stock data for m top technical analysis indicators
}
\description{
m top technical analysis function is to analyze the reversal pattern conform to the downward trend of stock data
}
\details{
use RSI analysis of the strength of the stock market trend, analyze trends conform to m top, and RSI function need library 'TTR'
}
\note{
the month value must be more than one month
}
\examples{
\dontrun{
library(quantmod)
aapl<-getSymbols("AAPL",src="yahoo",auto.assign=FALSE)
m_top(aapl,60,40,4,20)
}
}
\author{
Chun-Yu Liu <john401528@gmail.com>
}
